/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import com.epam.parso.Column;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import smile.data.DataFrame;
import smile.data.vector.DoubleVector;
import smile.data.vector.StringVector;
import smile.data.vector.ValueVector;
import smile.io.Input;

public interface SAS {
    public static DataFrame read(Path path) throws IOException {
        return SAS.read(Files.newInputStream(path, new OpenOption[0]), Integer.MAX_VALUE);
    }

    public static DataFrame read(String path) throws IOException, URISyntaxException {
        return SAS.read(Input.stream(path), Integer.MAX_VALUE);
    }

    public static DataFrame read(InputStream input, int limit) throws IOException {
        try (InputStream inputStream = input;){
            SasFileReaderImpl reader = new SasFileReaderImpl(input);
            SasFileProperties properties = reader.getSasFileProperties();
            List columns = reader.getColumns();
            int nrow = (int)properties.getRowCount();
            int ncol = (int)properties.getColumnsCount();
            Object[][] rows = new Object[Math.min(nrow, limit)][];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = reader.readNext();
            }
            ValueVector[] vectors = new ValueVector[ncol];
            for (int j = 0; j < ncol; ++j) {
                int i;
                String[] vector;
                Column column = (Column)columns.get(j);
                if (column.getType() == String.class) {
                    vector = new String[nrow];
                    for (i = 0; i < rows.length; ++i) {
                        vector[i] = (String)rows[i][j];
                    }
                    vectors[j] = new StringVector(column.getName(), vector);
                    continue;
                }
                vector = (String[])new double[nrow];
                for (i = 0; i < rows.length; ++i) {
                    vector[i] = (String)((Number)rows[i][j]).doubleValue();
                }
                vectors[j] = new DoubleVector(column.getName(), (double[])vector);
            }
            DataFrame dataFrame = new DataFrame(vectors);
            return dataFrame;
        }
    }
}

