/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.Suppliers;
import com.franciaflex.magalie.persistence.entity.Supplier;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public class SuppliersToReceive {
    protected boolean articlesWithoutSuppliers;
    protected boolean somethingToReceive;
    protected ImmutableSetMultimap<String, Supplier> suppliersByGroup;

    public SuppliersToReceive(Iterable<Supplier> suppliers) {
        this.somethingToReceive = !Iterables.isEmpty(suppliers);
        this.articlesWithoutSuppliers = Iterables.contains(suppliers, null);
        Ordering supplierGroupsOrder = Ordering.natural();
        Comparator suppliersOrdering = Suppliers.orderByNamesComparator();
        ImmutableListMultimap suppliersIndexedByGroups = Multimaps.index((Iterable)Iterables.filter(suppliers, (Predicate)Predicates.notNull()), (Function)Suppliers.getSupplierGroup());
        this.suppliersByGroup = ImmutableSetMultimap.builder().orderKeysBy((Comparator)supplierGroupsOrder).orderValuesBy(suppliersOrdering).putAll((Multimap)suppliersIndexedByGroups).build();
    }

    public boolean isSomethingToReceive() {
        return this.somethingToReceive;
    }

    public boolean isArticlesWithoutSuppliers() {
        return this.articlesWithoutSuppliers;
    }

    public ImmutableSetMultimap<String, Supplier> getSuppliersByGroup() {
        return this.suppliersByGroup;
    }
}

