/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.dao.BuildingJpaDao;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.StorageMovementJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.exception.InaccessibleLocationException;
import com.franciaflex.magalie.services.exception.InvalidMagalieBarcodeException;
import com.franciaflex.magalie.services.service.ArticleStorageService;
import com.franciaflex.magalie.services.service.BuildingsService;
import com.franciaflex.magalie.services.service.LocationErrorsService;
import com.franciaflex.magalie.services.service.MagalieBarcodeService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class StorageTransferService
implements MagalieService {
    private static final Log log = LogFactory.getLog(StorageTransferService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public Location getLocation(Building building, MagalieUser magalieUser, String barcode) throws InvalidMagalieBarcodeException, InaccessibleLocationException {
        MagalieBarcodeService magalieBarcodeService = this.serviceContext.newService(MagalieBarcodeService.class);
        Location location = magalieBarcodeService.getLocation(barcode, building);
        InaccessibleLocationException.checkLocationIsAccessible(location, magalieUser);
        return location;
    }

    public Location getLocation(String buildingId, MagalieUser magalieUser, String barcode) throws InvalidMagalieBarcodeException, InaccessibleLocationException {
        Preconditions.checkNotNull((Object)buildingId);
        BuildingJpaDao buildingDao = this.serviceContext.getPersistenceContext().getBuildingDao();
        Building building = (Building)buildingDao.findById(buildingId);
        return this.getLocation(building, magalieUser, barcode);
    }

    public Location getLocationById(String id) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        Location location = (Location)locationDao.findById(id);
        return location;
    }

    public List<StoredArticle> getStoredArticlesInLocation(Location location) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        Iterable<Object> storedArticles = storedArticleDao.findAllByLocation(location);
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        LinkedList<StorageMovement> allImpactingStoredArticle = new LinkedList<StorageMovement>();
        for (StoredArticle storedArticle : storedArticles) {
            allImpactingStoredArticle.addAll(storageMovementDao.findAllImpactingStoredArticle(storedArticle));
        }
        storedArticles = articleStorageService.computeActualQuantities(storedArticles, allImpactingStoredArticle);
        LocationErrorsService locationErrorsService = this.serviceContext.newService(LocationErrorsService.class);
        storedArticles = locationErrorsService.filterLocationInError(storedArticles);
        return Lists.newArrayList((Iterable)storedArticles);
    }

    public void confirmStorageTransfer(MagalieUser magalieUser, StoredArticle storedArticle, double quantity, Location destinationLocation) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        Date now = this.serviceContext.getNow();
        StorageMovement storageMovement = new StorageMovement();
        Location originLocation = storedArticle.getLocation();
        storageMovement.setOriginLocation(originLocation);
        storageMovement.setDestinationLocation(destinationLocation);
        storageMovement.setMagalieUser(magalieUser);
        storageMovement.setArticle(storedArticle.getArticle());
        storageMovement.setActualQuantity(Double.valueOf(quantity));
        storageMovement.setMovementDate(now);
        storageMovement.setConfirmDate(now);
        storageMovementDao.persist((JpaEntity)storageMovement);
        persistenceContext.commit();
        if (log.isInfoEnabled()) {
            log.info((Object)("storage movement recorded " + storageMovement));
        }
    }

    public List<Building> getDestinationBuildings(Company company) {
        BuildingsService buildingsService = this.serviceContext.newService(BuildingsService.class);
        List<Building> buildings = buildingsService.getAllBuildingsByCompany(company);
        return buildings;
    }
}

