/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.StoredArticles;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.StorageMovementJpaDao;
import com.franciaflex.magalie.persistence.dao.WarehouseJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StorageMovement;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.SimpleWithdrawItemTask;
import com.franciaflex.magalie.services.exception.IllegalWithdrawException;
import com.franciaflex.magalie.services.exception.InvalidMagalieBarcodeException;
import com.franciaflex.magalie.services.service.ArticleStorageService;
import com.franciaflex.magalie.services.service.MagalieBarcodeService;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class SimpleWithdrawItemService
implements MagalieService {
    private static final Log log = LogFactory.getLog(SimpleWithdrawItemService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public SimpleWithdrawItemTask getSimpleWithdrawItemTask(Building building, MagalieUser magalieUser, String articleBarcode) throws InvalidMagalieBarcodeException, IllegalWithdrawException {
        boolean articleIsAccessible;
        boolean articleAvailable;
        ArticleStorageService articleStorageService = this.serviceContext.newService(ArticleStorageService.class);
        MagalieBarcodeService magalieBarcodeService = this.serviceContext.newService(MagalieBarcodeService.class);
        Company company = magalieUser.getCompany();
        Article article = magalieBarcodeService.getArticle(articleBarcode, company);
        IllegalWithdrawException.checkWithdrawIsLegal(article);
        Iterable storedArticles = articleStorageService.getStoredArticles(building, article);
        Predicate articleStoredInAccessibleLocationPredicate = StoredArticles.articleStoredInAccessibleLocationPredicate((MagalieUser)magalieUser);
        boolean articleUnavailable = Iterables.isEmpty(storedArticles);
        boolean bl = articleAvailable = !articleUnavailable;
        boolean driverLicenseRequired = articleAvailable ? !(articleIsAccessible = Iterables.any(storedArticles, (Predicate)articleStoredInAccessibleLocationPredicate)) : false;
        storedArticles = Iterables.filter(storedArticles, (Predicate)articleStoredInAccessibleLocationPredicate);
        SimpleWithdrawItemTask simpleWithdrawItemTask = new SimpleWithdrawItemTask(article, storedArticles, driverLicenseRequired, articleUnavailable);
        return simpleWithdrawItemTask;
    }

    public void confirmStorageMovement(MagalieUser magalieUser, String destinationWarehouseId, StoredArticle storedArticle) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        WarehouseJpaDao warehouseDao = persistenceContext.getWarehouseDao();
        Date now = this.serviceContext.getNow();
        Location originLocation = storedArticle.getLocation();
        Article article = storedArticle.getArticle();
        double quantity = storedArticle.getQuantity();
        if (log.isInfoEnabled()) {
            log.info((Object)("user " + magalieUser.getLogin() + " took " + quantity + " " + article.getUnit() + " from " + originLocation.getBarcode()));
        }
        Warehouse destinationWarehouse = (Warehouse)warehouseDao.findById(destinationWarehouseId);
        Location destinationLocation = this.getDestinationLocation(destinationWarehouse);
        StorageMovement storageMovement = new StorageMovement();
        storageMovement.setOriginLocation(originLocation);
        storageMovement.setDestinationLocation(destinationLocation);
        storageMovement.setMagalieUser(magalieUser);
        storageMovement.setArticle(article);
        storageMovement.setActualQuantity(Double.valueOf(quantity));
        storageMovement.setConfirmDate(now);
        StorageMovementJpaDao storageMovementDao = persistenceContext.getStorageMovementDao();
        storageMovementDao.persist((JpaEntity)storageMovement);
        persistenceContext.commit();
    }

    protected Location getDestinationLocation(Warehouse destinationWarehouse) {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        Location location = locationDao.find(Locations.codeForWarehouseWithoutLocations(), destinationWarehouse);
        return location;
    }
}

