<%--
  #%L
  FaxToMail :: Web
  $Id: configuration-input.jsp 186 2014-06-11 11:02:07Z kmorin $
  $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/webapp/WEB-INF/content/admin/configuration-input.jsp $
  %%
  Copyright (C) 2014 Franciaflex, Code Lutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-3.0.html>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
  <head>
    <title>Configuration</title>
    
    <link rel="stylesheet" type="text/css" href="<s:url value='/nuiton-js/faxtomail-configuration.css' />" />
    <script type="text/javascript" src="<s:url value='/nuiton-js/faxtomail-configuration.js' />"></script>

    <script type="text/javascript">
      ConfigurationModule.value('ConfigurationData', {
          // enums
          'mailActions': <s:property value="toJson(mailActions)" escapeHtml="false"/>,
          'canBeRequiredMailFields': <s:property value="toJson(canBeRequiredMailFields)" escapeHtml="false"/>,
          'tableMailFields': <s:property value="toJson(tableMailFields)" escapeHtml="false"/>,
          'emailProtocolPorts': <s:property value="toJson(emailProtocolPorts)" escapeHtml="false"/>,
          // datas
          'configuration': <s:property value="toJson(configuration)" escapeHtml="false"/>,
          'etatAttentes': <s:property value="toJson(etatAttentes)" escapeHtml="false"/>,
          'etatAttentesUsage': <s:property value="toJson(etatAttentesUsage)" escapeHtml="false"/>,
          'demandTypes': <s:property value="toJson(demandTypes)" escapeHtml="false"/>,
          'mailFolders': <s:property value="toJson(mailFolders)" escapeHtml="false"/>,
          'mailFoldersUsage': <s:property value="toJson(mailFoldersUsage)" escapeHtml="false"/>,
          'searchDisplayColumns': <s:property value="toJson(configuration.searchDisplayColumns)" escapeHtml="false"/>,
          'mailFilters': <s:property value="toJson(mailFilters)" escapeHtml="false"/>,
          'emailAccounts': <s:property value="toJson(emailAccounts)" escapeHtml="false"/>,
          // referentiels
          'users': <s:property value="toJson(users)" escapeHtml="false"/>,
          'groups': <s:property value="toJson(groups)" escapeHtml="false"/>
      });
    </script>
  </head>

  <body>

    <div id="main-container" class="container" ng-app="ConfigurationModule">

      <h1 class="page-header">Configuration</h1>

      <s:form id="main_form" action="configuration" method="post" ng-controller="ConfigurationController">

        <!--<s:hidden name="activeTab"/>-->

        <ul id="tabs" class="nav nav-tabs">
          <li class="active"><a href="#tabs-general" data-toggle="tab">Général</a></li>
          <li><a href="#tabs-etatAttente" data-toggle="tab">États d'attente</a></li>
          <li><a href="#tabs-demandType" data-toggle="tab">Types de demandes</a></li>
          <li><a href="#tabs-tree" data-toggle="tab">Arborescence</a></li>
          <li><a href="#tabs-filters" data-toggle="tab">Filtres de mail</a></li>
          <li><a href="#tabs-search" data-toggle="tab">Recherche</a></li>
          <li><a href="#tabs-mailaccounts" data-toggle="tab">Comptes mail</a></li>
          <li><a href="#tabs-chefgroup" data-toggle="tab">Chef de groupe</a></li>
        </ul>

        <div class="tab-content active" ng-controller="ConfigurationMiscController">
          <input type="hidden" name="configurationJson" value="{{configuration}}" />

          <div id="tabs-general" class="tab-pane active">
            <!-- Général -->
            <div class="form-group">
              <label class="control-label" for="configurationEmailMaxSizeField">Taille maximale des email (en bits)</label>
              <input type="text" id="configurationEmailMaxSizeField" class="form-control" ng-model="configuration.emailMaxSize" />
            </div>

            <div class="form-group">
              Actions autorisées lorsque la demande n'a pas d'état d'attente et est <strong>invalide</strong> :
              <label class="checkbox" ng-repeat="(mailAction,label) in mailActions">
                <input type="checkbox" ng-checked="configuration.invalidFormDisabledActions.indexOf(mailAction) == -1"
                  ng-click="changeInvalidAction(mailAction)"> {{label}}
              </label>
            </div>

            <table class="table table-bordered">
              <caption>Commande de traitement des extensions de pièces jointes</caption>
              <thead>
                <tr>
                  <th>Extension</th>
                  <th>Commandes</th>
                </tr>
              </thead>
              <tbody>
                <tr ng-repeat="extensionCommand in configuration.extensionCommands">
                  <td class="col-xs-2">
                    <div class="form-group">
                      <input type="text" class="form-control" ng-model="extensionCommand.extension" size="5" placeholder="jpg" required>
                    </div>
                    <a class="pull-right btn btn-danger btn-xs " ng-click="deleteExtensionRow($index)" title="Supprimer l'extension">
                        <span class="glyphicon glyphicon-remove"></span></a>
                  </td>
                  <td>
                    <div class="form-group">
                      <label for="convertToToPdfField">Conversion en pdf :</label>
                      <input id="convertToToPdfField" type="text" class="form-control" ng-model="extensionCommand.convertToPdfCommand" placeholder="" />
                    </div>
                    <div class="form-group">
                      <label for="openAttachmentCommandField">Ouverture :</label>
                      <input id="openAttachmentCommandField" type="text" class="form-control" ng-model="extensionCommand.openAttachmentCommand" placeholder="" />
                    </div>
                  </td>
                </tr>
                <tr ng-if="!configuration.extensionCommands || configuration.extensionCommands.length == 0">
                  <td colspan="2" class="emptyTable">Aucune extension définie</td>
                </tr>
              </tbody>
              <tfoot>
                <tr>
                  <td colspan="2">
                    <a class="pull-right btn btn-success btn-xs" ng-click="addExtensionRow()" >
                      <span class="glyphicon glyphicon-plus"></span> Ajouter une ligne</a>
                  </td>
                </tr>
              </tfoot>
            </table>
          </div>

          <div id="tabs-etatAttente" class="tab-pane" ng-controller="ConfigurationEtatAttenteController">
            <input type="hidden" name="etatAttentesJson" value="{{etatAttentes}}" />

            <div class="row">
              <div class="col-md-4">
                <h3>États d'attente <input type="button" class="btn btn-success btn-xs pull-right" value="Nouveau" ng-click="newEtatAttente()" /></h3>
                <table class="table table-hover">
                  <tbody>
                    <tr ng-repeat="etatAttente in etatAttentes"
                        ng-class="{'info' : etatAttente == selectedEtatAttente}"
                        ng-click="editEtatAttente(etatAttente)">
                      <td>{{etatAttente.label}}
                      
                        <a class="pull-right btn btn-danger btn-xs" data-nodrag ng-click="deleteEtatAttente($index)"
                          ng-disabled="etatAttentesUsage[etatAttente.topiaId] > 0"
                          tooltip="{{etatAttentesUsage[etatAttente.topiaId] > 0 && 'Cet état d\'attente est utilisé et ne peut pas être supprimé'|| 'Supprimer cet état d\'attente'}}">
                          <span class="glyphicon glyphicon-remove"></span></a>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <div class="col-md-8" ng-if="selectedEtatAttente">
                <h3>Édition de l'état d'attente {{selectedEtatAttente.label}}</h3>
                Actions autorisées lorsque la demande est <strong>valide</strong> :
                <label class="checkbox" ng-repeat="(mailAction,label) in mailActions">
                  <input type="checkbox" ng-checked="selectedEtatAttente.validFormDisabledActions.indexOf(mailAction) == -1"
                    ng-click="changeEtatAttenteValidAction(mailAction)"> {{label}}
                </label>
                
                Actions autorisées lorsque la demande est <strong>invalide</strong> :
                <label class="checkbox" ng-repeat="(mailAction,label) in mailActions">
                  <input type="checkbox" ng-checked="selectedEtatAttente.invalidFormDisabledActions.indexOf(mailAction) == -1"
                    ng-click="changeEtatAttenteInvalidAction(mailAction)"> {{label}}
                </label>
              </div>
              <div class="col-md-8" ng-if="!selectedEtatAttente">
                <em>Sélectionnez un état d'attente.</em>
              </div>
            </div>

          </div>

          <div id="tabs-demandType" class="tab-pane" ng-controller="ConfigurationDemandTypeController">
            <input type="hidden" name="demandTypesJson" value="{{demandTypes}}" />

            <div class="row">
              <div class="col-md-4">
                <h3>Type de document <input type="button" class="btn btn-success btn-xs pull-right" value="Nouveau" ng-click="newDemandType()" /></h3>
                <table class="table table-hover">
                  <tbody>
                    <tr ng-repeat="demandType in demandTypes"
                        ng-class="{'info' : demandType == selectedDemandType}"
                        ng-click="editDemandType(demandType)">
                      <td>{{demandType.label}}</td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <div class="col-md-8" ng-if="selectedDemandType">
                <h3>Édition du type de document {{selectedDemandType.label}}</h3>
                Champs obligatoires pour le type de document :
                <label class="checkbox" ng-repeat="(mailField,label) in canBeRequiredMailFields">
                  <input type="checkbox" ng-checked="selectedDemandType.fields.indexOf(mailField) != -1"
                    ng-click="changeDemandTypeField(mailField)"> {{label}}
                </label>
              </div>
              <div class="col-md-8" ng-if="!selectedDemandType">
                <em>Sélectionnez un type de document.</em>
              </div>
            </div>

          </div>
          
          <div id="tabs-tree" class="tab-pane" ng-controller="ConfigurationTreeController">
            <input type="hidden" name="mailFoldersJson" value="{{mailFolders}}" />

            <div class="row">
              <div class="col-md-4">
                <h3>Dossiers <a class="btn btn-xs btn-success pull-right" ng-click="newRoot()">Nouveau</a></h3>
                <script type="text/ng-template" id="nodes_renderer.html">
                    <div ui-tree-handle ng-class="{'bg-success' : mailFolder == selectedMailFolder}">
                      <a class="btn btn-success btn-xs" data-nodrag ng-click="toggle(this)" ng-disabled="!mailFolder.children || mailFolder.children.length == 0">
                        <span class="glyphicon" ng-class="{'glyphicon-chevron-right': !collapsed, 'glyphicon-chevron-down': collapsed}"></span>
                      </a>
                      <a ng-click="editMailFolder(mailFolder)">{{mailFolder.name}} <span class="badge">{{mailFolder.$cumulativeCount}}</span></a>
                      <a class="pull-right btn btn-primary btn-xs" data-nodrag ng-click="newSubFolder(this)" style="margin-left: 8px;"><span class="glyphicon glyphicon-plus"></span></a>
                      <a class="pull-right btn btn-danger btn-xs" data-nodrag ng-click="deleteFolder(this)" ng-disabled="mailFolder.$cumulativeCount > 0"
                        tooltip="{{mailFolder.$cumulativeCount > 0 && 'Ce dossier contient ' + mailFolder.$cumulativeCount + ' demandes !'|| 'Supprimer ce dossier'}}">
                        <span class="glyphicon glyphicon-remove"></span></a>
                    </div>
                    <ol ui-tree-nodes="options" ng-model="mailFolder.children" ng-class="{hidden: !collapsed}">
                      <li ng-repeat="mailFolder in mailFolder.children" ui-tree-node ng-include="'nodes_renderer.html'">
                      </li>
                    </ol>
                  </script>
                <div ui-tree="options" data-drag-enabled="false">
                  <ol ui-tree-nodes="" ng-model="mailFolders" id="tree-root">
                    <li ng-repeat="mailFolder in mailFolders" ui-tree-node ng-include="'nodes_renderer.html'"></li>
                  </ol>
                </div>
              </div>
            
              <div class="col-md-8" ng-show="selectedMailFolder">
                <h3>Édition du dossier {{selectedMailFolder.name}}</h3>
                <div class="panel-group" id="accordion">

                  <!-- Général -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse0">
                          Généralité
                        </a>
                      </h4>
                    </div>
                    <div id="collapse0" class="panel-collapse collapse in">
                      <div class="panel-body">
                        <div class="form-group">
                          <label class="control-label">Autoriser le déplacement de demandes vers ce dossier ?</label><br />
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowMoveDemandIntoFolder" ng-value="true"> oui
                          </label>
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowMoveDemandIntoFolder" ng-value="false"> non
                          </label>
                          <label class="radio-inline" ng-if="selectedMailFolder.$parent">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowMoveDemandIntoFolder" ng-value="undefined"> hériter du dossier parent
                                ({{parentScopeValues.allowMoveDemandIntoFolder ? 'Oui' : 'Non'}})
                          </label>
                        </div>
                        <div class="form-group">
                          <label class="control-label">Autoriser la création de demandes dans ce dossier ?</label><br />
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowCreateDemandIntoFolder" ng-value="true"> oui
                          </label>
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowCreateDemandIntoFolder" ng-value="false"> non
                          </label>
                          <label class="radio-inline" ng-if="selectedMailFolder.$parent">
                            <input type="radio"
                                ng-model="selectedMailFolder.allowCreateDemandIntoFolder" ng-value="undefined"> hériter du dossier parent
                                ({{parentScopeValues.allowCreateDemandIntoFolder ? 'Oui' : 'Non'}})
                          </label>
                        </div>
                        <div class="form-group">
                          <label class="control-label">L'action imprimer est-elle équivalente à "prendre"</label><br />
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.printActionEqualTakeAction" ng-value="true"> oui
                          </label>
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.printActionEqualTakeAction" ng-value="false"> non
                          </label>
                          <label class="radio-inline" ng-if="selectedMailFolder.$parent">
                            <input type="radio"
                                ng-model="selectedMailFolder.printActionEqualTakeAction" ng-value="undefined"> hériter du dossier parent
                                ({{parentScopeValues.printActionEqualTakeAction ? 'Oui' : 'Non'}})
                          </label>
                        </div>
                        
                        <div class="form-group">
                          <label class="control-label">Ouvrir une pièce jointe sans prendre, met-il la ligne en orange ?</label><br />
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.openAttachmentReportNoTaken" ng-value="true"> oui
                          </label>
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.openAttachmentReportNoTaken" ng-value="false"> non
                          </label>
                          <label class="radio-inline" ng-if="selectedMailFolder.$parent">
                            <input type="radio"
                                ng-model="selectedMailFolder.openAttachmentReportNoTaken" ng-value="undefined"> hériter du dossier parent
                                ({{parentScopeValues.openAttachmentReportNoTaken ? 'Oui' : 'Non'}})
                          </label>
                        </div>
                        
                        <div class="form-group">
                          <label class="control-label">Refuser les mails dont l'email est inconnu de la base client</label><br />
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.rejectUnknownSender" ng-value="true"> oui
                          </label>
                          <label class="radio-inline">
                            <input type="radio"
                                ng-model="selectedMailFolder.rejectUnknownSender" ng-value="false"> non
                          </label>
                          <label class="radio-inline" ng-if="selectedMailFolder.$parent">
                            <input type="radio"
                                ng-model="selectedMailFolder.rejectUnknownSender" ng-value="undefined"> hériter du dossier parent
                                ({{parentScopeValues.rejectUnknownSender ? 'Oui' : 'Non'}})
                          </label>
                        </div>  

                        <hr />

                        <div class="form-group" ng-if="selectedMailFolder.$parent">
                          <label><input type="radio" ng-model="selectedMailFolder.useCurrentLevelEdiFolder" ng-value="false" />
                            Hériter du dossier de dépôt des demandes EDI sur le serveur :</label>
                          <input type="text" class="form-control" disabled
                              ng-model="parentScopeValues.ediFolder" ng-if="!selectedMailFolder.useCurrentLevelEdiFolder" />
                        </div>
                        <div class="form-group">
                          <label><input type="radio" ng-model="selectedMailFolder.useCurrentLevelEdiFolder" ng-value="true" ng-if="selectedMailFolder.$parent" />
                            Définir le dossier de dépôt des demandes EDI sur le serveur :</label>
                          <div class="input-group" ng-if="selectedMailFolder.useCurrentLevelEdiFolder || !selectedMailFolder.$parent">
                            <input type="text" class="form-control" ng-model="selectedMailFolder.ediFolder">
                            <span class="input-group-addon btn btn-info" ng-disabled="!selectedMailFolder.ediFolder"
                              tooltip="Fonctionnalité à venir">
                              <i class="fa fa-cogs"></i> Test
                            </span>
                          </div>
                        </div>

                        <hr />

                        <div class="form-group" ng-if="selectedMailFolder.$parent">
                          <label><input type="radio" ng-model="selectedMailFolder.useCurrentLevelFaxDomain" ng-value="false" />
                            Hériter du domaine des fax :</label>
                          <input type="text" class="form-control" disabled
                            ng-model="parentScopeValues.faxDomain" ng-if="!selectedMailFolder.useCurrentLevelFaxDomain">
                        </div>
                        <div class="form-group">
                          <label><input type="radio" ng-model="selectedMailFolder.useCurrentLevelFaxDomain" ng-value="true" ng-if="selectedMailFolder.$parent" />
                            Définir le domaine des fax :</label>
                          <input type="text" class="form-control" ng-model="selectedMailFolder.faxDomain" ng-if="selectedMailFolder.useCurrentLevelFaxDomain || !selectedMailFolder.$parent">
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Liste des chargés de clientèle -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse1">
                          Liste des chargés de clientèle
                        </a>
                      </h4>
                    </div>
                    <div id="collapse1" class="panel-collapse collapse">
                      <div class="panel-body">
                        <table class="table table-bordered">
                          <thead>
                            <tr>
                              <th>Utilisateur</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr ng-repeat="customerResponsible in parentScopeValues.customerResponsibles" class="parentInfos">
                              <td>
                                <span class="fa fa-user"></span>
                                {{customerResponsible.firstName}} {{customerResponsible.lastName}}</td>
                              <td>

                              </td>
                            </tr>
                            <tr ng-repeat="customerResponsible in selectedMailFolder.customerResponsibles">
                              <td>
                                <span class="fa fa-user"></span>
                                {{customerResponsible.firstName}} {{customerResponsible.lastName}}</td>
                              <td>
                                <a class="pull-right btn btn-danger btn-xs" ng-click="removeCustomerResponsible($index)">
                                  <span class="glyphicon glyphicon-remove"></span>
                                </a>
                              </td>
                            </tr>
                            <tr ng-if="!selectedMailFolder.customerResponsibles || selectedMailFolder.customerResponsibles.length == 0">
                              <td colspan="2" class="emptyTable">Aucun chargé de clientelle défini</td>
                            </tr>
                          </tbody>
                        </table>

                        <div class="form-inline">
                          <div class="form-group">
                            <label for="newCustomerResponsibleField" class="control-label">Nouveau :</label>
                            <select id="newCustomerResponsibleField" class="form-control" ng-model="newCustomerResponsible"
                                ng-options="user as user.firstName + ' ' + user.lastName for user in users"></select>
                          </div>
                          <a class="btn btn-success btn-xs" ng-click="addCustomerResponsible()" ng-disabled="!newCustomerResponsible">
                            <span class="glyphicon glyphicon-plus"></span>
                          </a>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Liste des emails expéditeur -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse2">
                          Liste des emails expéditeur
                        </a>
                      </h4>
                    </div>
                    <div id="collapse2" class="panel-collapse collapse">
                      <div class="panel-body">
                        <table class="table table-bordered">
                          <thead>
                            <tr>
                              <th>Adresse email</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr ng-repeat="replyAddress in parentScopeValues.replyAddresses" class="parentInfos">
                              <td>
                                <span class="glyphicon glyphicon-user"></span>
                                {{replyAddress}}</td>
                              <td>

                              </td>
                            </tr>
                            <tr ng-repeat="replyAddress in selectedMailFolder.replyAddresses track by $index">
                              <td>
                                <span class="glyphicon glyphicon-user"></span>
                                {{replyAddress}}</td>
                              <td>
                                <a class="pull-right btn btn-danger btn-xs" ng-click="removeReplyAddress($index)">
                                  <span class="glyphicon glyphicon-remove"></span>
                                </a>
                              </td>
                            </tr>
                            <tr ng-if="!selectedMailFolder.replyAddresses || selectedMailFolder.replyAddresses.length == 0">
                              <td colspan="2" class="emptyTable">Aucune adresse définie</td>
                            </tr>
                          </tbody>
                        </table>

                        <div class="form-inline" ng-form="addAddressForm" role="form">
                          <div class="form-group" 
                              ng-class="{'has-error': addAddressForm.address.$dirty && addAddressForm.address.$invalid,
                              'has-success': addAddressForm.address.$dirty && addAddressForm.address.$valid}">
                            <label for="newAddressField" class="control-label">Nouvelle adresse : </label>
                            <input id="newAddressField" class="form-control" name="address" type="email" ng-model="newReplyAddress" placeholder="nom.prenom@franciaflex.fr" />
                          </div>
                          <a class="btn btn-success btn-xs" ng-click="addReplyAddress()" ng-disabled="!newReplyAddress">
                            <span class="glyphicon glyphicon-plus"></span>
                          </a>
                        </div>

                        <br />

                        <table class="table table-bordered">
                          <thead>
                            <tr>
                              <th>Nom de domaine</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr ng-repeat="replyDomain in parentScopeValues.replyDomains" class="parentInfos">
                              <td>
                                <span class="glyphicon glyphicon-globe"></span>
                                {{replyDomain}}</td>
                              <td>

                              </td>
                            </tr>
                            <tr ng-repeat="replyDomain in selectedMailFolder.replyDomains track by $index">
                              <td>
                                <span class="glyphicon glyphicon-globe"></span>
                                {{replyDomain}}</td>
                              <td>
                                <a class="pull-right btn btn-danger btn-xs" ng-click="removeReplyDomain($index)">
                                  <span class="glyphicon glyphicon-remove"></span>
                                </a>
                              </td>
                            </tr>
                            <tr ng-if="!selectedMailFolder.replyDomains || selectedMailFolder.replyDomains.length == 0">
                              <td colspan="2" class="emptyTable">Aucune domaine défini</td>
                            </tr>
                          </tbody>
                        </table>
                         
                        <div class="form-inline" ng-form="addDomainForm" role="form">
                          <div class="form-group" 
                              ng-class="{'has-error': addDomainForm.domain.$dirty && addDomainForm.domain.$invalid,
                              'has-success': addDomainForm.domain.$dirty && addDomainForm.domain.$valid}">
                            <label for="newDomainField" class="control-label">Nouveau domaine : </label>
                            <input id="newDomainField" class="form-control" type="text" name="domain" ng-model="newReplyDomain" placeholder="franciaflex.fr" />
                          </div>
                          <a class="btn btn-success btn-xs" ng-click="addReplyDomain()" ng-disabled="!newReplyDomain">
                              <span class="glyphicon glyphicon-plus"></span>
                            </a>
                        </div>
                      </div>
                    </div>
                  </div>

                  <!-- Liste des emails expéditeur -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse3">
                          Sélection des états d'attentes possibles pour ce dossier
                        </a>
                      </h4>
                    </div>
                    <div id="collapse3" class="panel-collapse collapse">
                      <div class="panel-body">
                        <label ng-if="selectedMailFolder.$parent">
                          <input type="radio" ng-model="selectedMailFolder.useCurrentLevelEtatAttente"
                            ng-value="false" ng-change="initFolderEtatAttente()" />
                          Hériter des états d'attente déclarés sur les dossiers parent :
                        </label>
                        <label class="checkbox" ng-repeat="etatAttente in etatAttentes" ng-if="selectedMailFolder.$parent && !selectedMailFolder.useCurrentLevelEtatAttente">
                          <input type="checkbox" ng-checked="parentScopeValues.etatAttentes.indexOf(etatAttente) != -1"
                              disabled> {{etatAttente.label}}
                        </label>
                        <label>
                          <input type="radio" ng-model="selectedMailFolder.useCurrentLevelEtatAttente" ng-value="true"
                            ng-change="initFolderEtatAttente()" ng-if="selectedMailFolder.$parent" />
                          Définir des états d'attente pour ce dossier :
                        </label>
                        <label class="checkbox" ng-repeat="etatAttente in etatAttentes" ng-if="selectedMailFolder.useCurrentLevelEtatAttente || !selectedMailFolder.$parent">
                          <input type="checkbox" ng-checked="selectedMailFolder.etatAttentes.indexOf(etatAttente) != -1"
                              ng-click="changeFolderEtatAttente(etatAttente)"> {{etatAttente.label}}
                        </label>
                      </div>
                    </div>
                  </div>

                  <!-- configuration des colonnes a afficher -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse6">
                          Configuration des colonnes à afficher
                        </a>
                      </h4>
                    </div>
                    <div id="collapse6" class="panel-collapse collapse">
                      <div class="panel-body">

                        <label ng-if="selectedMailFolder.$parent">
                          <input type="radio" ng-model="selectedMailFolder.useCurrentLevelTableColumns"
                            ng-value="false" ng-change="initFolderColumns()" />
                          Hériter des colonnes déclarées sur les dossiers parent :
                        </label>

                        <div class="control-group" ng-show="selectedMailFolder.$parent && !selectedMailFolder.useCurrentLevelTableColumns">        
                          <div class="controls">
                            <input type="hidden" ui-select2-sortable ng-model="parentFolderTableColumns"
                                simple-query="getObjectsData" multiple sortable disabled>
                          </div>
                        </div>

                        <div ng-if="selectedMailFolder.$parent && !selectedMailFolder.useCurrentLevelTableColumns">
                          <table id='table-snapshot' class="table table-bordered">
                            <caption>Aperçu</caption>
                            <thead>
                              <tr>
                                <th ng-repeat="mailField in parentFolderTableColumns">{{tableMailFields[mailField.id]}}</th>
                              </tr>
                            </thead>
                          </table>
                        </div>
                        
                        <label>
                          <input type="radio" ng-model="selectedMailFolder.useCurrentLevelTableColumns" ng-value="true"
                            ng-change="initFolderColumns()" ng-if="selectedMailFolder.$parent" />
                          Définir les colonnes à afficher pour ce dossier :
                        </label>
                        
                        <div class="control-group" ng-show="!selectedMailFolder.$parent || selectedMailFolder.useCurrentLevelTableColumns">        
                          <div class="controls">
                            <input type="hidden" ui-select2-sortable ng-model="folderTableColumns"
                                simple-query="getObjectsData" multiple sortable>
                            <p class="help-block">(l'ordre peut être changé en faisant un glisser/déposer sur les champs)</p>
                          </div>
                        </div>

                        <div ng-if="!selectedMailFolder.$parent || selectedMailFolder.useCurrentLevelTableColumns">
                          <table id='table-snapshot' class="table table-bordered">
                            <caption>Aperçu</caption>
                            <thead>
                              <tr>
                                <th ng-repeat="mailField in folderTableColumns">{{tableMailFields[mailField.id]}}</th>
                              </tr>
                            </thead>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                  
                  <!-- Droits -->
                  <div class="panel panel-default">
                    <div class="panel-heading">
                      <h4 class="panel-title">
                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse4">
                          Droits
                        </a>
                      </h4>
                    </div>
                    <div id="collapse4" class="panel-collapse collapse">
                      <div class="panel-body">
                        <!-- Droits d'accès -->
                        <table id="rights" class="table table-bordered">
                          <thead>
                            <tr>
                              <th>Utilisateur ou groupe</th>
                              <th>Droits</th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr ng-repeat="group in parentScopeValues.rightGroups" class="parentInfos">
                              <td>
                                <span class="fa fa-users"></span> {{group.fullPath}}
                              </td>
                              <td>
                               <label><input type="checkbox" ng-checked="parentScopeValues.readRightGroups.indexOf(group) != -1" disabled> Lecture</label>
                               <label><input type="checkbox" ng-checked="parentScopeValues.writeRightGroups.indexOf(group) != -1" disabled> Écriture</label>
                               <label><input type="checkbox" ng-checked="parentScopeValues.moveRightGroups.indexOf(group) != -1" disabled> Déplacement</label>
                              </td>
                            </tr>
                            <tr ng-repeat="user in parentScopeValues.rightUsers" class="parentInfos">
                              <td>
                                <span class="fa fa-user"></span> {{user.firstName}} {{user.lastName}}
                              </td>
                              <td>
                               <label><input type="checkbox" ng-checked="parentScopeValues.readRightUsers.indexOf(user) != -1" disabled> Lecture</label>
                               <label><input type="checkbox" ng-checked="parentScopeValues.writeRightUsers.indexOf(user) != -1" disabled> Écriture</label>
                               <label><input type="checkbox" ng-checked="parentScopeValues.moveRightUsers.indexOf(user) != -1" disabled> Déplacement</label>
                              </td>
                            </tr>
                          </tbody>
                          <tbody>
                            <tr ng-repeat="group in selectedMailFolder.rightGroups">
                              <td>
                                <span class="fa fa-users"></span> {{group.fullPath}}
                                <a class="pull-right btn btn-danger btn-xs pull-right" ng-click="removeWriteRightGroup($index)">
                                  <span class="glyphicon glyphicon-remove"></span>
                                </a>
                              </td>
                              <td>
                               <label><input type="checkbox"
                                    ng-model="readRightGroup"
                                    ng-checked="selectedMailFolder.readRightGroups.indexOf(group) != -1"
                                    ng-disabled="parentScopeValues.readRightGroups.indexOf(group) != -1"
                                    ng-change="changeReadRightGroup(group)"> Lecture</label>
                               <label><input type="checkbox"
                                    ng-model="writeRightGroup"
                                    ng-checked="selectedMailFolder.writeRightGroups.indexOf(group) != -1"
                                    ng-disabled="parentScopeValues.writeRightGroups.indexOf(group) != -1"
                                    ng-change="changeWriteRightGroup(group)"> Écriture</label>
                               <label><input type="checkbox"
                                    ng-model="moveRightGroup"
                                    ng-checked="selectedMailFolder.moveRightGroups.indexOf(group) != -1"
                                    ng-disabled="parentScopeValues.moveRightGroups.indexOf(group) != -1"
                                    ng-change="changeMoveRightGroup(group)"> Déplacement</label>
                              </td>
                            </tr>
                            <tr ng-repeat="user in selectedMailFolder.rightUsers">
                              <td>
                                <span class="fa fa-user"></span> {{user.firstName}} {{user.lastName}}
                                <a class="pull-right btn btn-danger btn-xs pull-right" ng-click="removeWriteRightUser($index)">
                                  <span class="glyphicon glyphicon-remove"></span>
                                </a>
                              </td>
                              <td>
                               <label><input type="checkbox"
                                    ng-model="readRightUser"
                                    ng-checked="selectedMailFolder.readRightUsers.indexOf(user) != -1"
                                    ng-disabled="parentScopeValues.readRightUsers.indexOf(user) != -1"
                                    ng-change="changeReadRightUser(user)"> Lecture</label>
                               <label><input type="checkbox"
                                    ng-model="writeRightUser"
                                    ng-checked="selectedMailFolder.writeRightUsers.indexOf(user) != -1"
                                    ng-disabled="parentScopeValues.writeRightUsers.indexOf(user) != -1"
                                    ng-change="changeWriteRightUser(user)"> Écriture</label>
                               <label><input type="checkbox"
                                    ng-model="moveRightUser"
                                    ng-checked="selectedMailFolder.moveRightUsers.indexOf(user) != -1"
                                    ng-disabled="parentScopeValues.moveRightUsers.indexOf(user) != -1"
                                    ng-change="changeMoveRightUser(user)"> Déplacement</label>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                        <div class="form-inline">
                          <div class="form-group">
                            <label for="newRightUserField" class="control-label">Nouveau utilisateur :</label>
                            <select id="newRightUserField" class="form-control"
                                ng-model="newRightUser" ng-options="user as user.firstName + ' ' + user.lastName for user in users">
                            </select>
                            <a class="btn btn-success btn-xs" ng-click="addRightUser()" ng-disabled="!newRightUser">
                              <span class="glyphicon glyphicon-plus"></span>
                            </a>
                          </div>
                        </div>
                        
                        <div class="form-inline">
                          <div class="form-group">
                            <label for="newRightGroupField" class="control-label">Nouveau groupe :</label>
                            <select id="newRightGroupField" class="form-control"
                                ng-model="newRightGroup" ng-options="group as group.fullPath for group in groups">
                            </select>
                            <a class="btn btn-success btn-xs" ng-click="addRightGroup()" ng-disabled="!newRightGroup">
                              <span class="glyphicon glyphicon-plus"></span>
                            </a>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
              </div>
            </div>
          </div>
        </div>

        <div id="tabs-filters" class="tab-pane" ng-controller="ConfigurationFilterController">
          <input type="hidden" name="mailFiltersJson" value="{{mailFilters}}" />
          
          <div class="panel panel-default">
            <div class="panel-heading" ng-repeat-start="mailFolder in mailFolders">
              <h4 class="panel-title">
                <a data-toggle="collapse" data-parent="#accordion" href="#mailFilerAccordion{{$index}}">
                  Filtre du dossier {{mailFolder.name}}
                </a>
              </h4>
            </div>
            <div id="mailFilerAccordion{{$index}}" class="panel-collapse collapse" ng-repeat-end>
              <div class="panel-body">
                <table class="table table-hover table-bordered">
                  <thead>
                    <tr>
                      <th>Filtre</th>
                      <th>Dossier</th>
                      <th/>
                    </tr>
                  </thead>
                  <tbody ui-sortable="sortableOptions" ng-model="rootFolderMailFilters[mailFolder.topiaId]">
                    <tr ng-repeat="mailFilter in rootFolderMailFilters[mailFolder.topiaId]">
                      <td>{{mailFilter.expression}}</td>
                      <td>{{mailFilter.mailFolder.$fullPath}}</td>
                      <td><a class="btn btn-danger btn-xs" ng-click="removeFilter(mailFolder, mailFilter)">
                          <span class="glyphicon glyphicon-remove"></span>
                        </a></td>
                    </tr>
                  </tbody>
                </table>
                
                <div role="form">
                  <div class="form-group">
                    <label for="filterField">Filtre</label>
                    <input type="text" class="form-control" id="folderField" ng-model="newFilter.expression">
                  </div>
                  <div class="form-group">
                    <label for="folderField">Dossier</label>
                    <select class="form-control" ng-model="newFilter.mailFolder" ng-options="mailFolder.$fullPath for mailFolder in flatMailFolders[mailFolder.topiaId]"></select>
                  </div>
                </div>
                <button type="button" class="btn btn-success" ng-disabled="!newFilter.expression || !newFilter.mailFolder" ng-click="addNewFilter(mailFolder)">
                  <i class="glyphicon glyphicon-plus"></i> Ajouter
                </button>
              </div>
            </div>
          </div>
        </div>

        <div id="tabs-search" class="tab-pane" ng-controller="ConfigurationSearchController">
          <!-- <input type="hidden" name="configuration.searchDisplayColumns" value="{{searchDisplayColumn.id}}" ng-repeat="searchDisplayColumn in searchDisplayColumns"/> -->

          <div class="control-group">
              <label class="control-label" for="tableColumns">Champs à afficher dans le tableau (l'ordre peut être changé en faisant un glisser/déposer sur les champs)</label>

              <div class="controls">
                <input type="hidden" ui-select2-sortable ng-model="searchDisplayColumns" simple-query="getObjectsData" multiple sortable>
              </div>

              <div>
                <table id='table-snapshot' class="table table-bordered">
                  <caption>Aperçu</caption>
                  <thead>
                    <tr>
                      <th ng-repeat="etatAttenteField in searchDisplayColumns">{{tableMailFields[etatAttenteField.id]}}</th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
        </div>
        
        <div id="tabs-mailaccounts" class="tab-pane" ng-controller="ConfigurationEmailAccountsController">
          <input type="hidden" name="emailAccountsJson" value="{{emailAccounts}}" />

          <table id='table-snapshot' class="table table-bordered">
            <thead>
              <tr>
                <th>Protocole</th>
                <th>Serveur</th>
                <th>Port</th>
                <th>Utilisateur</th>
                <th/>
              </tr>
            </thead>
            <tbody>
              <tr ng-repeat="emailAccount in emailAccounts">
                <td>{{emailAccount.protocol}}</td>
                <td>{{emailAccount.host}}</td>
                <td>{{emailAccount.port}}</td>
                <td>{{emailAccount.login}}</td>
                <td>
                  <a class="btn btn-danger btn-xs" ng-click="removeEmailAccount($index)">
                    <span class="glyphicon glyphicon-remove"></span>
                  </a></td>
              </tr>
            </tbody>
          </table>
          
          <div class="form row" role="form" ng-form="addEmailAccountForm">
            <div class="form-group col-xs-1">
              <label for="emailAccountProtocol" class="control-label">Protocole:</label>
              <!-- <input type="text" class="form-control" ng-model="newAccount.protocol" /> -->
              <select id="emailAccountProtocol" ng-model="newAccount.protocol" ng-options="protocol as protocol for (protocol, port) in emailProtocolPorts"></select>
            </div>
            <div class="form-group col-xs-4">
              <label for="emailAccountHost" class="control-label">Serveur:</label>
              <input id="emailAccountHost" name="newAccountHost" type="text" class="form-control" ng-model="newAccount.host" ng-minlength="1" />
            </div>
            <div class="form-group col-xs-1"
                ng-class="{'has-error': addEmailAccountForm.newAccountPort.$dirty && addEmailAccountForm.newAccountPort.$invalid,
                           'has-success': addEmailAccountForm.newAccountPort.$dirty && addEmailAccountForm.newAccountPort.$valid}">
              <label for="emailAccountPort" class="control-label">Port:</label>
              <input id="emailAccountPort" name="newAccountPort" type="text" class="form-control" ng-model="newAccount.port" ng-pattern="/^\d+$/" />
            </div>
            <div class="form-group col-xs-2">
              <label for="emailAccountUser" class="control-label">Utilisateur:</label>
              <input id="emailAccountUser" type="text" class="form-control" ng-model="newAccount.login"/>
            </div>
            <div class="form-group col-xs-2">
              <label for="emailAccountPassword" class="control-label">Mot de passe:</label>
              <input id="emailAccountPassword" type="password" class="form-control" ng-model="newAccount.password">
            </div>
            <div class="form-group col-xs-2">
              <br />
              <button type="button" class="btn btn-info" ng-disabled="!newAccount.protocol || !newAccount.host || !newAccount.port || !newAccount.login || addEmailAccountForm.$invalid"
                tooltip="Fonctionnalité à venir">
                <i class="fa fa-cogs"></i> Test
              </button>
              <button type="button" class="btn btn-success" ng-disabled="!newAccount.protocol || !newAccount.host || !newAccount.port || !newAccount.login || addEmailAccountForm.$invalid" ng-click="addEmailAccount()">
                <i class="fa fa-plus"></i> Ajouter
              </button>
            </div>
          </div>
        </div>

        <div id="tabs-chefgroup" class="tab-pane" ng-controller="ConfigurationChefGroupController">

          <div class="row">
            <div class="col-md-4">
              <h3>Chef de groupe <input type="button" class="btn btn-success btn-xs pull-right" value="Nouveau" ng-click="newGroupChef()" /></h3>
              <table class="table table-hover">
                <tbody>
                  <tr ng-repeat="groupChef in configuration.chefs"
                      ng-class="{'info' : groupChef == selectedGroupChef}"
                      ng-click="editGroupChef(groupChef)">
                    <td>{{groupChef.userGroup ? groupChef.userGroup.fullPath : '(aucun groupe)'}}  
                      <a class="btn btn-danger btn-xs pull-right" ng-click="removeGroupChef(groupChef, $index)">
                        <span class="glyphicon glyphicon-remove"></span>
                      </a>
                    </td>
                  </tr>
                  <tr ng-if="!configuration.chefs || configuration.chefs.length == 0">
                    <td class="emptyTable">Aucun chef de groupe</td>
                  </tr>
                </tbody>
              </table>
            </div>

            <div class="col-md-8" ng-show="selectedGroupChef">
              <h3>Édition du chef de groupe</h3>
              
              <div class="form-inline">
                <div class="form-group required">
                  <label for="groupChefUserGroupField" class="control-label">Chef du groupe : </label>
                  <select id="groupChefUserGroupField" class="form-control" ng-required="selectedGroupChef"
                    ng-model="selectedGroupChef.userGroup"
                    ng-options="group as group.fullPath for group in groups">
                      <option value="" ng-if="!selectedGroupChef.userGroup"></option>
                    </select>
                </div>
              </div>

              <hr />
              <table class="table table-hover">
                <thead>
                  <tr>
                    <th>Groupes gérés par le chef de groupe</th>
                  </tr>
                </thead>
                <tbody>
                  <tr ng-repeat="group in selectedGroupChef.managedGroups">
                    <td>
                    <span class="fa fa-users"></span>
                    {{group.fullPath}}
                    <a class="btn btn-danger btn-xs pull-right" ng-click="removeManagedGroup($index)">
                      <span class="glyphicon glyphicon-remove"></span>
                    </a>
                    </td>
                  </tr>
                  <tr ng-if="!selectedGroupChef.managedGroups || selectedGroupChef.managedGroups.length == 0">
                    <td class="emptyTable">Aucun groupe gérés</td>
                  </tr>
                </tbody>
              </table>
              <div class="form-inline">
                <div class="form-group">
                  <label for="newManagedGroupField" class="control-label">Nouveau groupe :</label>
                  <select id="newManagedGroupField" class="form-control"
                      ng-model="newManagedGroup" ng-options="group as group.fullPath for group in groups">
                  </select>
                  <a class="btn btn-success btn-xs" ng-click="addManagedGroup()" ng-disabled="!newManagedGroup">
                    <span class="glyphicon glyphicon-plus"></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
      <nav class="navbar navbar-default navbar-fixed-bottom">
        <div class="container">
          <button type="submit" class="btn btn-primary navbar-btn pull-right">Valider</button>
        </div>
      </nav>
    </s:form>
  </div>
  </body>
</html>
