package com.franciaflex.faxtomail.web.job;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: AbstractFaxToMailJob.java 149 2014-06-08 12:48:03Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/job/AbstractFaxToMailJob.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.quartz.Job;
import org.quartz.JobExecutionContext;

import com.franciaflex.faxtomail.services.FaxToMailServiceContext;

public abstract class AbstractFaxToMailJob implements Job {

    public static final String SERVICE_CONTEXT = "serviceContext";

    protected FaxToMailServiceContext getServiceContext(JobExecutionContext jobExecutionContext) {
        FaxToMailServiceContext serviceContext = (FaxToMailServiceContext) jobExecutionContext.getMergedJobDataMap().get(SERVICE_CONTEXT);
        return serviceContext;
    }
}
