package com.franciaflex.faxtomail.web;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: DefaultFaxToMailWebApplicationContext.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/DefaultFaxToMailWebApplicationContext.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.services.service.FaxToMailWebApplicationContext;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;

public class DefaultFaxToMailWebApplicationContext implements FaxToMailWebApplicationContext {

    private static final Log log = LogFactory.getLog(DefaultFaxToMailWebApplicationContext.class);

    protected String instanceUrl;

    public DefaultFaxToMailWebApplicationContext(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected String formatUrl(String actionUrl) {
        Map<String, String> emptyMap = Collections.emptyMap();
        return formatUrl(actionUrl, emptyMap);
    }

    protected String formatUrl(String actionUrl, Map<String, String> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(instanceUrl).append("/").append(actionUrl);
        if ( ! parameters.isEmpty()) {
            SortedSet<String> queryStringElements = Sets.newTreeSet();
            try {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    String queryStringElement = parameter.getKey() + '=' + URLEncoder.encode(parameter.getValue(), Charsets.UTF_8.name());
                    queryStringElements.add(queryStringElement);
                }
            } catch (UnsupportedEncodingException e) {
                if (log.isErrorEnabled()) {
                    log.error("should never occur", e);
                }
                throw new ApplicationTechnicalException(e);
            }
            stringBuilder.append('?').append(Joiner.on('&').join(queryStringElements));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getAdministrationUrl(FaxToMailUser extranetUser) {
        ImmutableMap<String, String> params =
                ImmutableMap.of("yearlyDeclarationId", extranetUser.getTopiaId());
        return formatUrl("administration/edit-user!input", params);
    }

}
