package com.franciaflex.faxtomail;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: FaxToMailApplicationContext.java 130 2014-06-04 14:43:27Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/FaxToMailApplicationContext.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.FaxToMailWebApplicationContext;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.web.DefaultFaxToMailWebApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

import java.io.File;

public class FaxToMailApplicationContext {

    private static Log log = LogFactory.getLog(FaxToMailApplicationContext.class);

    public static final String APPLICATION_CONTEXT_PARAMETER = "faxToMailApplicationContext";

    protected static FaxToMailTopiaApplicationContext topiaApplicationContext;

    protected static FaxToMailConfiguration applicationConfig;

    public static FaxToMailConfiguration getApplicationConfig() {
        if (applicationConfig == null) {
            applicationConfig = new FaxToMailConfiguration("faxToMail.properties");
        }
        return applicationConfig;
    }

    public static FaxToMailTopiaApplicationContext getTopiaApplicationContext() {
        if (topiaApplicationContext == null) {
            topiaApplicationContext = new FaxToMailTopiaApplicationContext(getApplicationConfig().getTopiaProperties());
        }
        return topiaApplicationContext;
    }

    public FaxToMailTopiaPersistenceContext newPersistenceContext() {

        FaxToMailTopiaPersistenceContext persistenceContext = getTopiaApplicationContext().newPersistenceContext();

        return persistenceContext;

    }

    public FaxToMailServiceContext newServiceContext(FaxToMailTopiaPersistenceContext persistenceContext) {

        FaxToMailServiceContext newServiceContext =
                new FaxToMailServiceContext();

        FaxToMailConfiguration applicationConfig = getApplicationConfig();

        newServiceContext.setApplicationConfig(applicationConfig);

        newServiceContext.setPersistenceContext(persistenceContext);

        FaxToMailWebApplicationContext webApplicationContext =
                new DefaultFaxToMailWebApplicationContext(applicationConfig.getInstanceUrl());

        newServiceContext.setWebApplicationContext(webApplicationContext);

        return newServiceContext;

    }

    public void close() {
        if (topiaApplicationContext != null) {
            topiaApplicationContext.close();
        }
    }

    public void init() {

        if (getApplicationConfig().isLogConfigurationProvided()) {

            File log4jConfigurationFile = getApplicationConfig().getLogConfigurationFile();

            String log4jConfigurationFileAbsolutePath = log4jConfigurationFile.getAbsolutePath();

            if (log4jConfigurationFile.exists()) {

                if (log.isInfoEnabled()) {
                    log.info("will use logging configuration " + log4jConfigurationFileAbsolutePath);
                }

                // reset logger configuration
                LogManager.resetConfiguration();

                // use generate log config file
                PropertyConfigurator.configure(log4jConfigurationFileAbsolutePath);

                log = LogFactory.getLog(FaxToMailApplicationContext.class);

            } else {
                if (log.isWarnEnabled()) {
                    log.warn("there is no file " + log4jConfigurationFileAbsolutePath + ". Default logging configuration will be used.");
                }
            }

        } else {
            log.info("will use default logging configuration");
        }

//        I18nInitializer initializer = new DefaultI18nInitializer("faxtomail");

//        I18n.init(initializer, Locale.FRANCE);

//        LocalizedTextUtil.addDefaultResourceBundle("i18n.faxtomail-web");

        FaxToMailTopiaPersistenceContext persistenceContext = newPersistenceContext();

        FaxToMailServiceContext serviceContext = newServiceContext(persistenceContext);

        InitFaxToMailService initExtranetService =
                serviceContext.newService(InitFaxToMailService.class);

        initExtranetService.init();

        persistenceContext.close();

    }

}
