/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PluginRegistry<T extends Serializable> {
    private final ConcurrentMap<String, ConcurrentMap<String, T>> categories = new ConcurrentHashMap<String, ConcurrentMap<String, T>>();

    public ConcurrentMap<String, T> getCategory(String category) {
        if (category == null) {
            throw new IllegalArgumentException("Category name cannot be null.");
        }
        String key = category.toLowerCase();
        this.categories.putIfAbsent(key, new ConcurrentHashMap());
        return (ConcurrentMap)this.categories.get(key);
    }

    public int getCategoryCount() {
        return this.categories.size();
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    public void clear() {
        this.categories.clear();
    }

    public boolean hasCategory(String category) {
        if (category == null) {
            throw new IllegalArgumentException("Category name cannot be null.");
        }
        String key = category.toLowerCase();
        return this.categories.containsKey(key) && !((ConcurrentMap)this.categories.get(key)).isEmpty();
    }

    public Set<Map.Entry<String, ConcurrentMap<String, T>>> getCategories() {
        return this.categories.entrySet();
    }
}

