/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.attachment.ButtonAttachment;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class AttachmentCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachmentCellEditor.class);
    protected final ButtonAttachment editorButton;
    protected FaxToMailUIContext context;
    protected AttachmentEditorUIModel.AttachmentListener listener;

    public static TableCellEditor newEditor(FaxToMailUI ui) {
        return new AttachmentCellEditor(FaxToMailUIContext.getApplicationContext());
    }

    public AttachmentCellEditor(FaxToMailUIContext context) {
        this.context = context;
        this.editorButton = new ButtonAttachment("faxtomail.attachmentCellRenderer.text", null);
        this.editorButton.setBorder(new LineBorder(Color.BLACK));
        this.editorButton.setEditable(false);
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                AttachmentCellEditor.this.editorButton.setSelected(false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                AttachmentCellEditor.this.editorButton.setSelected(false);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)table.getModel();
        int modelRow = table.convertRowIndexToModel(row);
        final DemandeUIModel model = (DemandeUIModel)tableModel.getEntry(modelRow);
        this.editorButton.init(model);
        this.listener = new AttachmentEditorUIModel.AttachmentListener(){

            @Override
            public void onAttachmentOpened(Attachment attachment, boolean original) {
                String topiaId = model.getTopiaId();
                if (topiaId != null) {
                    String filename = original ? attachment.getOriginalFile().getFilename() : FaxToMailUIUtil.getEditedFileName(attachment.getOriginalFile());
                    Email email = AttachmentCellEditor.this.context.getEmailService().addToHistory(topiaId, HistoryType.ATTACHMENT_OPENING, AttachmentCellEditor.this.context.getCurrentUser(), new Date(), new String[]{filename});
                    model.fromEntity(email);
                }
            }

            @Override
            public void onAttachmentEdited(Attachment attachment) {
                String topiaId = model.getTopiaId();
                Email email = AttachmentCellEditor.this.context.getEmailService().addToHistory(topiaId, HistoryType.ATTACHMENT_MODIFICATION, AttachmentCellEditor.this.context.getCurrentUser(), new Date(), new String[]{FaxToMailUIUtil.getEditedFileName(attachment.getOriginalFile())});
                model.fromEntity(email);
            }
        };
        this.editorButton.getBean().addAttachmentListener(this.listener);
        return this.editorButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        AttachmentEditorUIModel model = this.editorButton.getBean();
        Preconditions.checkNotNull((Object)((Object)model), (Object)"No model found in editor.");
        Collection<Attachment> result = model.getAttachment();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor value: " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.editorButton.getBean().removeAttachmentListener(this.listener);
            this.editorButton.init(null);
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        this.editorButton.getBean().removeAttachmentListener(this.listener);
        this.editorButton.init(null);
        super.cancelCellEditing();
    }
}

