package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.ui.swing.actions.SearchAction;
import com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeListAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * Handler of UI {@link SearchUIHandler}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SearchUIHandler extends AbstractFaxToMailDemandListHandler<SearchUIModel, SearchUI> implements CloseableUI {

    /** Logger. */
    private static final Log log = LogFactory.getLog(SearchUIHandler.class);

    @Override
    public void beforeInit(SearchUI ui) {
        super.beforeInit(ui);

        SearchUIModel searchUIModel = getContext().getSearch();
        if (searchUIModel == null) {
            searchUIModel = new SearchUIModel();
//            searchUIModel.setTakenBy(getContext().getCurrentUser());
//            searchUIModel.setModifiedBy(getContext().getCurrentUser());

            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.MONTH, -2);
            Date twoMonthsAgo = cal.getTime();

//            searchUIModel.setMaxModificationDate(now);
//            searchUIModel.setMinModificationDate(twoMonthsAgo);
            searchUIModel.setMaxReceptionDate(now);
            searchUIModel.setMinReceptionDate(twoMonthsAgo);
            //searchUIModel.setMaxPrintingDate(now);
            //searchUIModel.setMinPrintingDate(twoMonthsAgo);
        }

        getUI().setContextValue(searchUIModel);
    }

    @Override
    public void afterInit(SearchUI ui) {

        initUI(ui);

        final ReferentielService referentielService = getContext().getReferentielService();

        SearchUIModel model = getModel();
        initBeanFilterableComboBox(ui.getTakenByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getTakenBy());
        initBeanFilterableComboBox(ui.getModifiedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getModifiedBy());
        initBeanFilterableComboBox(ui.getArchivedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getArchivedBy());
        initBeanFilterableComboBox(ui.getTransferByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getTransferBy());
        initBeanFilterableComboBox(ui.getPrintedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getPrintingBy());
        initBeanFilterableComboBox(ui.getRepliedByComboBox(),
                                   getContext().getUserService().getAllUsers(),
                                   model.getReplyBy());

        initCheckBoxComboBox(ui.getDocTypeComboBox(),
                             referentielService.getAllDemandType(),
                             model.getDemandType(),
                             EmailFilter.PROPERTY_DEMAND_TYPE,
                             true);
        initCheckBoxComboBox(ui.getPriorityComboBox(),
                             referentielService.getAllPriority(),
                             model.getPriority(),
                             EmailFilter.PROPERTY_PRIORITY,
                             true);
        initCheckBoxComboBox(ui.getEtatAttenteComboBox(),
                             referentielService.getAllEtatAttente(),
                             model.getEtatAttente(),
                             EmailFilter.PROPERTY_ETAT_ATTENTE,
                             true);
        initCheckBoxComboBox(ui.getStatusComboBox(),
                             Arrays.asList(DemandStatus.values()),
                             model.getDemandStatus(),
                             EmailFilter.PROPERTY_DEMAND_STATUS,
                             false);
        initCheckBoxComboBox(ui.getGammeComboBox(),
                             referentielService.getAllRange(),
                             model.getGamme(),
                             EmailFilter.PROPERTY_GAMME,
                             false);

        final JXTable dataTable = getUI().getDataTable();
        dataTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

        initDemandeTable(dataTable, true);

        model.addPropertyChangeListener(SearchUIModel.PROPERTY_RESULTS, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List<DemandeUIModel> emails = (List<DemandeUIModel>) evt.getNewValue();
                AbstractApplicationTableModel<DemandeUIModel> dataTableModel = (AbstractApplicationTableModel<DemandeUIModel>) dataTable.getModel();
                dataTableModel.setRows(emails);
                showInformationMessage(t("faxtomail.search.resultNb", emails.size()));

                DemandeUIModel currentEmail = getContext().getCurrentEmail();
                if (currentEmail != null) {
                    int row = dataTableModel.getRowIndex(currentEmail);
                    if (row > 0) {
                        dataTable.setRowSelectionInterval(row, row);
                    }
                }
            }
        });

        if (getContext().getSearch() != null) {
            try {
                SearchAction searchAction = getContext().getActionFactory().createLogicAction(this, SearchAction.class);
                searchAction.doAction();

            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("error while searching", e);
                }
                getContext().getErrorHelper().showErrorDialog(t("faxtomail.search.action.error"));
            }
        }

    }

    @Override
    protected List<MailField> getColumns() {
        List<MailField> tableColumns = getContext().getFaxToMailConfiguration().getSearchDisplayColumns();
        return tableColumns;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getModifiedByComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }
        clearValidators();
    }

    @Override
    public boolean quitUI() {
//        boolean result = quitScreen(
//                getModel().isValid(),
//                getModel().isModify(),
//                _("tutti.editCruise.askCancelEditBeforeLeaving.cancelSaveCruise"),
//                _("tutti.editCruise.askSaveBeforeLeaving.saveCruise"),
//                ui.getSaveButton().getAction()
//        );
//        return result;
        return true;
    }

    @Override
    public SwingValidator<SearchUIModel> getValidator() {
        return null;
    }

    @Override
    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);

        int selectedRowCount = getUI().getDataTable().getSelectedRowCount();

        SearchUIModel model = getModel();
        model.setMenuEnabled(selectedRowCount == 1);
    }

    public void goToMenu() {
        JXTable dataTable = ui.getDataTable();
        int rowIndex = dataTable.getSelectedRow();
        rowIndex = dataTable.convertRowIndexToModel(rowIndex);
        DemandeUIModel selectedEmail = ((DemandeTableModel) dataTable.getModel()).getEntry(rowIndex);
        getContext().setCurrentEmail(selectedEmail);
        getContext().setCurrentMailFolder(selectedEmail.getMailFolder());
        getContext().getActionEngine().runAction(new ShowDemandeListAction(getContext().getMainUI().getHandler()));
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        return new MailField[] { MailField.ATTACHMENT, MailField.REPLIES };
    }

}
