/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.ButtonDemandReplies;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class RepliesCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepliesCellEditor.class);
    protected final ButtonDemandReplies editorButton;
    protected FaxToMailUIContext context;

    public static TableCellEditor newEditor(FaxToMailUI ui) {
        return new RepliesCellEditor(FaxToMailUIContext.getApplicationContext());
    }

    public RepliesCellEditor(FaxToMailUIContext context) {
        this.context = context;
        this.editorButton = new ButtonDemandReplies("faxtomail.demandRepliesCellRenderer.text", null);
        this.editorButton.setBorder(new LineBorder(Color.BLACK));
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                RepliesCellEditor.this.editorButton.setSelected(false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                RepliesCellEditor.this.editorButton.setSelected(false);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)table.getModel();
        int modelRow = table.convertRowIndexToModel(row);
        DemandeUIModel model = (DemandeUIModel)tableModel.getEntry(modelRow);
        this.editorButton.init(model);
        return this.editorButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        DemandeUIModel model = this.editorButton.getBean();
        Preconditions.checkNotNull((Object)model, (Object)"No model found in editor.");
        Collection<Reply> result = model.getReplies();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor value: " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.editorButton.init(null);
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        this.editorButton.init(null);
        super.cancelCellEditing();
    }
}

