/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaMigrationService;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.event.TopiaEntitiesVetoable;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.event.TopiaSchemaListener;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.event.TopiaTransactionVetoable;
import org.nuiton.topia.persistence.internal.DefaultTopiaIdFactory;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.internal.support.TopiaServiceSupportImpl;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;

public abstract class AbstractTopiaApplicationContext<K extends TopiaPersistenceContext>
implements TopiaApplicationContext<K> {
    private static final Log log = LogFactory.getLog(AbstractTopiaApplicationContext.class);
    protected TopiaIdFactory topiaIdFactory;
    protected ImmutableMap<String, String> configuration;
    protected TopiaFiresSupport topiaFiresSupport = new TopiaFiresSupport();
    protected TopiaServiceSupport topiaServiceSupport;
    protected HibernateProvider hibernateProvider;
    protected TopiaHibernateSessionRegistry sessionRegistry = new TopiaHibernateSessionRegistry();
    protected boolean closed = false;
    protected Set<TopiaPersistenceContext> persistenceContexts = Collections.newSetFromMap(new WeakHashMap());

    public AbstractTopiaApplicationContext(Properties properties) {
        this((Map<String, String>)ImmutableMap.copyOf((Map)properties));
    }

    public AbstractTopiaApplicationContext(Map<String, String> configuration) {
        HashMap configurationCopy = Maps.newHashMap();
        configurationCopy.putAll(configuration);
        if (!configuration.containsKey("topia.persistence.classes")) {
            configurationCopy.put("topia.persistence.classes", this.getImplementationClassesAsString());
        }
        this.configuration = ImmutableMap.copyOf((Map)configurationCopy);
        this.init();
    }

    protected void init() {
        this.initServices();
    }

    protected void initServices() {
        TopiaServiceSupportImpl topiaServiceSupportImpl = new TopiaServiceSupportImpl();
        this.topiaServiceSupport = topiaServiceSupportImpl;
        topiaServiceSupportImpl.initServices(this);
        this.getHibernateProvider().getHibernateConfiguration();
    }

    @Override
    public boolean isInitSchema() {
        String initSchemaConfigurationValue = (String)this.getConfiguration().get((Object)"topia.persistence.initSchema");
        boolean initSchema = StringUtils.isBlank((CharSequence)initSchemaConfigurationValue) || Boolean.parseBoolean(initSchemaConfigurationValue);
        return initSchema;
    }

    @Override
    public void initSchema() {
        Map<String, TopiaMigrationService> services = this.getServices(TopiaMigrationService.class);
        Collection<TopiaMigrationService> migrationServices = services.values();
        if (this.isSchemaEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"schema is empty, will create");
            }
            this.createSchema();
            for (TopiaMigrationService migrationService : migrationServices) {
                migrationService.initOnCreateSchema();
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"schema exists, will try to migrate");
            }
            if (migrationServices.isEmpty()) {
                throw new TopiaMigrationServiceException("no migration service found");
            }
            if (migrationServices.size() > 1) {
                throw new TopiaMigrationServiceException("configuration " + this.getConfiguration() + " provide more than one migration service: " + migrationServices);
            }
            if ("update".equalsIgnoreCase((String)this.getConfiguration().get((Object)"hibernate.hbm2ddl.auto"))) {
                throw new IllegalStateException("your configuration include a migration service and hibernate.hbm2ddl.auto to 'update' value. That will lead to a inconsistent state of the schema");
            }
            TopiaMigrationService migrationService = (TopiaMigrationService)Iterables.getOnlyElement(migrationServices);
            migrationService.runSchemaMigration();
        }
    }

    protected abstract Class<? extends TopiaEntity>[] getImplementationClasses();

    protected String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<TopiaEntity> aClass : this.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    protected void registerPersistenceContext(TopiaPersistenceContext persistenceContext) {
        this.persistenceContexts.add(persistenceContext);
    }

    public HibernateProvider getHibernateProvider() {
        if (this.hibernateProvider == null) {
            this.hibernateProvider = new HibernateProvider((Map<String, String>)this.configuration, this.topiaServiceSupport, this.sessionRegistry);
        }
        return this.hibernateProvider;
    }

    protected TopiaListenableSupport getTopiaListenableSupport() {
        return this.topiaFiresSupport;
    }

    @Override
    public ImmutableMap<String, String> getConfiguration() {
        return this.configuration;
    }

    protected TopiaIdFactory getTopiaIdFactory() {
        if (this.topiaIdFactory == null) {
            String topiaIdFactoryClassName = (String)this.getConfiguration().get((Object)"topia.persistence.topiaIdFactoryClassName");
            if (StringUtils.isEmpty((CharSequence)topiaIdFactoryClassName)) {
                this.topiaIdFactory = new DefaultTopiaIdFactory();
            } else {
                try {
                    Class<?> topiaIdFactoryClass = Class.forName(topiaIdFactoryClassName);
                    Preconditions.checkState((boolean)TopiaIdFactory.class.isAssignableFrom(topiaIdFactoryClass), (Object)(topiaIdFactoryClassName + " is not a valid class name. The class must implements " + TopiaIdFactory.class.getSimpleName()));
                    this.topiaIdFactory = (TopiaIdFactory)topiaIdFactoryClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaException("Unable to create user specified TopiaIdFactory", e);
                }
                catch (InstantiationException e) {
                    throw new TopiaException("Unable to create user specified TopiaIdFactory", e);
                }
                catch (IllegalAccessException e) {
                    throw new TopiaException("Unable to create user specified TopiaIdFactory", e);
                }
            }
        }
        return this.topiaIdFactory;
    }

    public TopiaHibernateSessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.addTopiaEntityListener(listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.topiaFiresSupport.addTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.removeTopiaEntityListener(listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.topiaFiresSupport.removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntityVetoable(vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntityVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        this.topiaFiresSupport.addTopiaTransactionListener(listener);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        this.topiaFiresSupport.removeTopiaTransactionListener(listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.topiaFiresSupport.addTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.topiaFiresSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.topiaFiresSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addTopiaSchemaListener(TopiaSchemaListener listener) {
        this.topiaFiresSupport.addTopiaSchemaListener(listener);
    }

    @Override
    public void removeTopiaSchemaListener(TopiaSchemaListener listener) {
        this.topiaFiresSupport.removeTopiaSchemaListener(listener);
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.topiaServiceSupport.getServices();
    }

    @Override
    public <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService) {
        return this.topiaServiceSupport.getServices();
    }

    @Override
    public List<Class<?>> getPersistenceClasses() {
        return this.getHibernateProvider().getPersistentClasses();
    }

    @Override
    public boolean isSchemaEmpty() {
        Configuration configuration = this.getHibernateProvider().getHibernateConfiguration();
        boolean result = TopiaUtil.isSchemaEmpty(configuration);
        return result;
    }

    @Override
    public boolean isTableExists(Class<?> clazz) {
        Configuration configuration = this.getHibernateProvider().getHibernateConfiguration();
        boolean result = TopiaUtil.isSchemaExist(configuration, clazz.getName());
        return result;
    }

    @Override
    public String getSchemaName() {
        return (String)this.getConfiguration().get((Object)"hibernate.default_schema");
    }

    @Override
    public void createSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            new SchemaExport(this.getHibernateProvider().getHibernateConfiguration()).execute(showSchema, true, false, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void showCreateSchema() {
        try {
            new SchemaExport(this.getHibernateProvider().getHibernateConfiguration()).execute(true, false, false, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not show create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void updateSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            new SchemaUpdate(this.getHibernateProvider().getHibernateConfiguration()).execute(showSchema, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not update schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void dropSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            new SchemaExport(this.getHibernateProvider().getHibernateConfiguration()).execute(showSchema, true, true, false);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not drop schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"TopiaApplicationContext was already closed");
        if (log.isDebugEnabled()) {
            log.debug((Object)("will close " + this));
        }
        for (TopiaPersistenceContext persistenceContext : this.persistenceContexts) {
            if (persistenceContext == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"null TopiaPersistenceContext found in #persistenceContexts");
                continue;
            }
            try {
                if (persistenceContext.isClosed()) continue;
                persistenceContext.close();
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"unable to close TopiaPersistenceContext", (Throwable)eee);
            }
        }
        this.hibernateProvider.close();
        this.closed = true;
        TopiaApplicationContextCache.removeContext(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " closed"));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

