package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Oct 16 14:49:27 CEST 2015")
public abstract class GeneratedMailFolderTopiaDao<E extends MailFolder> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) MailFolder.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.MailFolder;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            MailFilterTopiaDao dao = topiaDaoSupplier
                    .getDao(MailFilter.class, MailFilterTopiaDao.class);
            List<MailFilter> list = dao
                    .forProperties(MailFilter.PROPERTY_MAIL_FOLDER, entity)
                    .findAll();
            for (MailFilter item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMailFolder())) {
                    item.setMailFolder(null);
                }
            
            }
        }

        {
            EmailTopiaDao dao = topiaDaoSupplier
                    .getDao(Email.class, EmailTopiaDao.class);
            List<Email> list = dao
                    .forProperties(Email.PROPERTY_MAIL_FOLDER, entity)
                    .findAll();
            for (Email item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMailFolder())) {
                    item.setMailFolder(null);
                }
            
            }
        }

        {
            MailFolderTopiaDao dao = topiaDaoSupplier
                    .getDao(MailFolder.class, MailFolderTopiaDao.class);
            List<MailFolder> list = dao
                    .forProperties(MailFolder.PROPERTY_PARENT, entity)
                    .findAll();
            for (MailFolder item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getParent())) {
                    item.setParent(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM faxToMailUser main, affectedfolders_faxtomailuser secondary " +
                    " WHERE main.topiaid=secondary.faxToMailUser " +
                    " AND secondary.affectedFolders='" + entity.getTopiaId() + "'";
            List<FaxToMailUser> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", FaxToMailEntityEnum.FaxToMailUser.getImplementation())
                    .list();

            for (FaxToMailUser item : list) {
                item.removeAffectedFolders(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String name, MailFolder parent) {
        return forNaturalId(name, parent).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String name, MailFolder parent) {
        return forNaturalId(name, parent).exists();
    }

    public E createByNaturalId(String name, MailFolder parent) {
        return create(MailFolder.PROPERTY_NAME, name, MailFolder.PROPERTY_PARENT, parent);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String name, MailFolder parent) {
        return forProperties(MailFolder.PROPERTY_NAME, name, MailFolder.PROPERTY_PARENT, parent);
    }

    public E createByNotNull(String name) {
        return create(MailFolder.PROPERTY_NAME, name);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiTransferIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_EDI_TRANSFER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiTransferEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_EDI_TRANSFER, v);
        return result;
    }

    @Deprecated
    public E findByEdiTransfer(Boolean v) {
        return forEdiTransferEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdiTransfer(Boolean v) {
        return forEdiTransferEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAllowCreateDemandIntoFolderIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAllowCreateDemandIntoFolderEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByAllowCreateDemandIntoFolder(Boolean v) {
        return forAllowCreateDemandIntoFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAllowCreateDemandIntoFolder(Boolean v) {
        return forAllowCreateDemandIntoFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAllowMoveDemandIntoFolderIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAllowMoveDemandIntoFolderEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByAllowMoveDemandIntoFolder(Boolean v) {
        return forAllowMoveDemandIntoFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAllowMoveDemandIntoFolder(Boolean v) {
        return forAllowMoveDemandIntoFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectUnknownSenderIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_REJECT_UNKNOWN_SENDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectUnknownSenderEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_REJECT_UNKNOWN_SENDER, v);
        return result;
    }

    @Deprecated
    public E findByRejectUnknownSender(Boolean v) {
        return forRejectUnknownSenderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRejectUnknownSender(Boolean v) {
        return forRejectUnknownSenderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectResponseMailAddressIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_REJECT_RESPONSE_MAIL_ADDRESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectResponseMailAddressEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_REJECT_RESPONSE_MAIL_ADDRESS, v);
        return result;
    }

    @Deprecated
    public E findByRejectResponseMailAddress(String v) {
        return forRejectResponseMailAddressEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRejectResponseMailAddress(String v) {
        return forRejectResponseMailAddressEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectResponseMessageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_REJECT_RESPONSE_MESSAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectResponseMessageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_REJECT_RESPONSE_MESSAGE, v);
        return result;
    }

    @Deprecated
    public E findByRejectResponseMessage(String v) {
        return forRejectResponseMessageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRejectResponseMessage(String v) {
        return forRejectResponseMessageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReplyAddressesContains(String v) {
        return forContains(MailFolder.PROPERTY_REPLY_ADDRESSES, v);
    }

    @Deprecated
    public E findContainsReplyAddresses(String v) {
        return forReplyAddressesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsReplyAddresses(String v) {
        return forReplyAddressesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReplyDomainsContains(String v) {
        return forContains(MailFolder.PROPERTY_REPLY_DOMAINS, v);
    }

    @Deprecated
    public E findContainsReplyDomains(String v) {
        return forReplyDomainsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsReplyDomains(String v) {
        return forReplyDomainsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOpenAttachmentReportNoTakenIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOpenAttachmentReportNoTakenEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, v);
        return result;
    }

    @Deprecated
    public E findByOpenAttachmentReportNoTaken(Boolean v) {
        return forOpenAttachmentReportNoTakenEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOpenAttachmentReportNoTaken(Boolean v) {
        return forOpenAttachmentReportNoTakenEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrintActionEqualTakeActionIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrintActionEqualTakeActionEquals(Boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, v);
        return result;
    }

    @Deprecated
    public E findByPrintActionEqualTakeAction(Boolean v) {
        return forPrintActionEqualTakeActionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPrintActionEqualTakeAction(Boolean v) {
        return forPrintActionEqualTakeActionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiFolderIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_EDI_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdiFolderEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_EDI_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByEdiFolder(String v) {
        return forEdiFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdiFolder(String v) {
        return forEdiFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxDomainIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_FAX_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxDomainEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_FAX_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByFaxDomain(String v) {
        return forFaxDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFaxDomain(String v) {
        return forFaxDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelWaitingStateIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_WAITING_STATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelWaitingStateEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_WAITING_STATE, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelWaitingState(boolean v) {
        return forUseCurrentLevelWaitingStateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelWaitingState(boolean v) {
        return forUseCurrentLevelWaitingStateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelTableColumnsIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelTableColumnsEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelTableColumns(boolean v) {
        return forUseCurrentLevelTableColumnsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelTableColumns(boolean v) {
        return forUseCurrentLevelTableColumnsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelFaxDomainIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelFaxDomainEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelFaxDomain(boolean v) {
        return forUseCurrentLevelFaxDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelFaxDomain(boolean v) {
        return forUseCurrentLevelFaxDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelEdiFolderIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelEdiFolderEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelEdiFolder(boolean v) {
        return forUseCurrentLevelEdiFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelEdiFolder(boolean v) {
        return forUseCurrentLevelEdiFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRejectResponseMailAddressIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MAIL_ADDRESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRejectResponseMailAddressEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MAIL_ADDRESS, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelRejectResponseMailAddress(boolean v) {
        return forUseCurrentLevelRejectResponseMailAddressEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelRejectResponseMailAddress(boolean v) {
        return forUseCurrentLevelRejectResponseMailAddressEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRejectResponseMessageIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MESSAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRejectResponseMessageEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MESSAGE, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelRejectResponseMessage(boolean v) {
        return forUseCurrentLevelRejectResponseMessageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelRejectResponseMessage(boolean v) {
        return forUseCurrentLevelRejectResponseMessageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelDemandTypeIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_DEMAND_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelDemandTypeEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_DEMAND_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelDemandType(boolean v) {
        return forUseCurrentLevelDemandTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelDemandType(boolean v) {
        return forUseCurrentLevelDemandTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRangeIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_RANGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelRangeEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_RANGE, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelRange(boolean v) {
        return forUseCurrentLevelRangeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelRange(boolean v) {
        return forUseCurrentLevelRangeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchiveFolderIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_ARCHIVE_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArchiveFolderEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_ARCHIVE_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByArchiveFolder(boolean v) {
        return forArchiveFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByArchiveFolder(boolean v) {
        return forArchiveFolderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFolderTableColumnsIn(Collection<List<MailField>> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_FOLDER_TABLE_COLUMNS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFolderTableColumnsEquals(List<MailField> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_FOLDER_TABLE_COLUMNS, v);
        return result;
    }

    @Deprecated
    public E findByFolderTableColumns(List<MailField> v) {
        return forFolderTableColumnsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFolderTableColumns(List<MailField> v) {
        return forFolderTableColumnsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_COMPANY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCompanyEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_COMPANY, v);
        return result;
    }

    @Deprecated
    public E findByCompany(String v) {
        return forCompanyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCompany(String v) {
        return forCompanyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelCompanyIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_USE_CURRENT_LEVEL_COMPANY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUseCurrentLevelCompanyEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_USE_CURRENT_LEVEL_COMPANY, v);
        return result;
    }

    @Deprecated
    public E findByUseCurrentLevelCompany(boolean v) {
        return forUseCurrentLevelCompanyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUseCurrentLevelCompany(boolean v) {
        return forUseCurrentLevelCompanyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaitingStatesContains(WaitingState v) {
        return forContains(MailFolder.PROPERTY_WAITING_STATES, v);
    }

    @Deprecated
    public E findContainsWaitingStates(WaitingState v) {
        return forWaitingStatesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsWaitingStates(WaitingState v) {
        return forWaitingStatesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forChildrenContains(MailFolder v) {
        return forContains(MailFolder.PROPERTY_CHILDREN, v);
    }

    @Deprecated
    public E findContainsChildren(MailFolder v) {
        return forChildrenContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsChildren(MailFolder v) {
        return forChildrenContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParentIn(Collection<MailFolder> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFolder.PROPERTY_PARENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParentEquals(MailFolder v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFolder.PROPERTY_PARENT, v);
        return result;
    }

    @Deprecated
    public E findByParent(MailFolder v) {
        return forParentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByParent(MailFolder v) {
        return forParentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCustomerResponsiblesContains(FaxToMailUser v) {
        return forContains(MailFolder.PROPERTY_CUSTOMER_RESPONSIBLES, v);
    }

    @Deprecated
    public E findContainsCustomerResponsibles(FaxToMailUser v) {
        return forCustomerResponsiblesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsCustomerResponsibles(FaxToMailUser v) {
        return forCustomerResponsiblesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReadRightUsersContains(FaxToMailUser v) {
        return forContains(MailFolder.PROPERTY_READ_RIGHT_USERS, v);
    }

    @Deprecated
    public E findContainsReadRightUsers(FaxToMailUser v) {
        return forReadRightUsersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsReadRightUsers(FaxToMailUser v) {
        return forReadRightUsersContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMoveRightUsersContains(FaxToMailUser v) {
        return forContains(MailFolder.PROPERTY_MOVE_RIGHT_USERS, v);
    }

    @Deprecated
    public E findContainsMoveRightUsers(FaxToMailUser v) {
        return forMoveRightUsersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMoveRightUsers(FaxToMailUser v) {
        return forMoveRightUsersContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWriteRightGroupsContains(FaxToMailUserGroup v) {
        return forContains(MailFolder.PROPERTY_WRITE_RIGHT_GROUPS, v);
    }

    @Deprecated
    public E findContainsWriteRightGroups(FaxToMailUserGroup v) {
        return forWriteRightGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsWriteRightGroups(FaxToMailUserGroup v) {
        return forWriteRightGroupsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMoveRightGroupsContains(FaxToMailUserGroup v) {
        return forContains(MailFolder.PROPERTY_MOVE_RIGHT_GROUPS, v);
    }

    @Deprecated
    public E findContainsMoveRightGroups(FaxToMailUserGroup v) {
        return forMoveRightGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMoveRightGroups(FaxToMailUserGroup v) {
        return forMoveRightGroupsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReadRightGroupsContains(FaxToMailUserGroup v) {
        return forContains(MailFolder.PROPERTY_READ_RIGHT_GROUPS, v);
    }

    @Deprecated
    public E findContainsReadRightGroups(FaxToMailUserGroup v) {
        return forReadRightGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsReadRightGroups(FaxToMailUserGroup v) {
        return forReadRightGroupsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDemandTypesContains(DemandType v) {
        return forContains(MailFolder.PROPERTY_DEMAND_TYPES, v);
    }

    @Deprecated
    public E findContainsDemandTypes(DemandType v) {
        return forDemandTypesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsDemandTypes(DemandType v) {
        return forDemandTypesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRangesContains(Range v) {
        return forContains(MailFolder.PROPERTY_RANGES, v);
    }

    @Deprecated
    public E findContainsRanges(Range v) {
        return forRangesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsRanges(Range v) {
        return forRangesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWriteRightUsersContains(FaxToMailUser v) {
        return forContains(MailFolder.PROPERTY_WRITE_RIGHT_USERS, v);
    }

    @Deprecated
    public E findContainsWriteRightUsers(FaxToMailUser v) {
        return forWriteRightUsersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsWriteRightUsers(FaxToMailUser v) {
        return forWriteRightUsersContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forChildrenContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFolder.class) {
            MailFolderTopiaDao dao =
                topiaDaoSupplier.getDao(MailFolder.class, MailFolderTopiaDao.class);
            tmp = dao.forParentEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == MailFilter.class) {
            MailFilterTopiaDao dao =
                topiaDaoSupplier.getDao(MailFilter.class, MailFilterTopiaDao.class);
            tmp = dao.forMailFolderEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forMailFolderEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == FaxToMailUser.class) {
            FaxToMailUserTopiaDao dao =
                topiaDaoSupplier.getDao(FaxToMailUser.class, FaxToMailUserTopiaDao.class);
            tmp = dao.forAffectedFoldersContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(MailFolder.class, entity);
        if (!list.isEmpty()) {
            result.put(MailFolder.class, list);
        }

        list = findUsages(MailFilter.class, entity);
        if (!list.isEmpty()) {
            result.put(MailFilter.class, list);
        }

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        list = findUsages(FaxToMailUser.class, entity);
        if (!list.isEmpty()) {
            result.put(FaxToMailUser.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMailFolderTopiaDao<E extends MailFolder>
