package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Sep 02 17:46:33 CEST 2015")
public abstract class FaxToMailUserAbstract extends AbstractTopiaEntity implements FaxToMailUser {

    /**
     * Nom de l'attribut en BD : lastName
     */
    protected String lastName;

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : trigraph
     */
    protected String trigraph;

    /**
     * Nom de l'attribut en BD : firstName
     */
    protected String firstName;

    /**
     * Nom de l'attribut en BD : hidden
     */
    protected boolean hidden;

    /**
     * Nom de l'attribut en BD : userGroups
     */
    protected Collection<FaxToMailUserGroup> userGroups;

    /**
     * Nom de l'attribut en BD : affectedFolders
     */
    protected Collection<MailFolder> affectedFolders;

    /**
     * Nom de l'attribut en BD : signings
     */
    protected Collection<Stamp> signings;

    /**
     * Nom de l'attribut en BD : defaultSigning
     */
    protected Stamp defaultSigning;

    private static final long serialVersionUID = 3545232548679464242L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_LAST_NAME, String.class, lastName);
        visitor.visit(this, PROPERTY_LOGIN, String.class, login);
        visitor.visit(this, PROPERTY_TRIGRAPH, String.class, trigraph);
        visitor.visit(this, PROPERTY_FIRST_NAME, String.class, firstName);
        visitor.visit(this, PROPERTY_HIDDEN, boolean.class, hidden);
        visitor.visit(this, PROPERTY_USER_GROUPS, Collection.class, FaxToMailUserGroup.class, userGroups);
        visitor.visit(this, PROPERTY_AFFECTED_FOLDERS, Collection.class, MailFolder.class, affectedFolders);
        visitor.visit(this, PROPERTY_SIGNINGS, Collection.class, Stamp.class, signings);
        visitor.visit(this, PROPERTY_DEFAULT_SIGNING, Stamp.class, defaultSigning);
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getLastName() {
        String result = this.lastName;
        return result;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getLogin() {
        String result = this.login;
        return result;
    }

    @Override
    public void setTrigraph(String trigraph) {
        this.trigraph = trigraph;
    }

    @Override
    public String getTrigraph() {
        String result = this.trigraph;
        return result;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getFirstName() {
        String result = this.firstName;
        return result;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        boolean result = this.hidden;
        return result;
    }

    @Override
    public void addUserGroups(FaxToMailUserGroup userGroups) {
        if (this.userGroups == null) {
            this.userGroups = new LinkedList<FaxToMailUserGroup>();
        }
        this.userGroups.add(userGroups);
    }

    @Override
    public void addAllUserGroups(Collection<FaxToMailUserGroup> userGroups) {
        if (userGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : userGroups) {
            addUserGroups(item);
        }
    }

    @Override
    public void setUserGroups(Collection<FaxToMailUserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    @Override
    public void removeUserGroups(FaxToMailUserGroup userGroups) {
        if (this.userGroups == null || !this.userGroups.remove(userGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearUserGroups() {
        if (this.userGroups == null) {
            return;
        }
        this.userGroups.clear();
    }

    @Override
    public Collection<FaxToMailUserGroup> getUserGroups() {
        return userGroups;
    }

    @Override
    public FaxToMailUserGroup getUserGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(userGroups, topiaId);
    }

    @Override
    public Collection<String> getUserGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getUserGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeUserGroups() {
        if (userGroups == null) {
            return 0;
        }
        return userGroups.size();
    }

    @Override
    public boolean isUserGroupsEmpty() {
        int size = sizeUserGroups();
        return size == 0;
    }

    @Override
    public boolean isUserGroupsNotEmpty() {
        boolean empty = isUserGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsUserGroups(FaxToMailUserGroup userGroups) {
        boolean contains = this.userGroups !=null && this.userGroups.contains(userGroups);
        return contains;
    }

    @Override
    public void addAffectedFolders(MailFolder affectedFolders) {
        if (this.affectedFolders == null) {
            this.affectedFolders = new LinkedList<MailFolder>();
        }
        this.affectedFolders.add(affectedFolders);
    }

    @Override
    public void addAllAffectedFolders(Collection<MailFolder> affectedFolders) {
        if (affectedFolders == null) {
            return;
        }
        for (MailFolder item : affectedFolders) {
            addAffectedFolders(item);
        }
    }

    @Override
    public void setAffectedFolders(Collection<MailFolder> affectedFolders) {
        this.affectedFolders = affectedFolders;
    }

    @Override
    public void removeAffectedFolders(MailFolder affectedFolders) {
        if (this.affectedFolders == null || !this.affectedFolders.remove(affectedFolders)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearAffectedFolders() {
        if (this.affectedFolders == null) {
            return;
        }
        this.affectedFolders.clear();
    }

    @Override
    public Collection<MailFolder> getAffectedFolders() {
        return affectedFolders;
    }

    @Override
    public MailFolder getAffectedFoldersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(affectedFolders, topiaId);
    }

    @Override
    public Collection<String> getAffectedFoldersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.MailFolder> tmp = getAffectedFolders();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeAffectedFolders() {
        if (affectedFolders == null) {
            return 0;
        }
        return affectedFolders.size();
    }

    @Override
    public boolean isAffectedFoldersEmpty() {
        int size = sizeAffectedFolders();
        return size == 0;
    }

    @Override
    public boolean isAffectedFoldersNotEmpty() {
        boolean empty = isAffectedFoldersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsAffectedFolders(MailFolder affectedFolders) {
        boolean contains = this.affectedFolders !=null && this.affectedFolders.contains(affectedFolders);
        return contains;
    }

    @Override
    public void addSignings(Stamp signings) {
        if (this.signings == null) {
            this.signings = new LinkedList<Stamp>();
        }
        this.signings.add(signings);
    }

    @Override
    public void addAllSignings(Collection<Stamp> signings) {
        if (signings == null) {
            return;
        }
        for (Stamp item : signings) {
            addSignings(item);
        }
    }

    @Override
    public void setSignings(Collection<Stamp> signings) {
        this.signings = signings;
    }

    @Override
    public void removeSignings(Stamp signings) {
        if (this.signings == null || !this.signings.remove(signings)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSignings() {
        if (this.signings == null) {
            return;
        }
        this.signings.clear();
    }

    @Override
    public Collection<Stamp> getSignings() {
        return signings;
    }

    @Override
    public Stamp getSigningsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(signings, topiaId);
    }

    @Override
    public Collection<String> getSigningsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.Stamp> tmp = getSignings();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSignings() {
        if (signings == null) {
            return 0;
        }
        return signings.size();
    }

    @Override
    public boolean isSigningsEmpty() {
        int size = sizeSignings();
        return size == 0;
    }

    @Override
    public boolean isSigningsNotEmpty() {
        boolean empty = isSigningsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSignings(Stamp signings) {
        boolean contains = this.signings !=null && this.signings.contains(signings);
        return contains;
    }

    @Override
    public void setDefaultSigning(Stamp defaultSigning) {
        this.defaultSigning = defaultSigning;
    }

    @Override
    public Stamp getDefaultSigning() {
        Stamp result = this.defaultSigning;
        return result;
    }

} //FaxToMailUserAbstract
