package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Mon Aug 31 10:12:26 CEST 2015")
public abstract class ConfigurationAbstract extends AbstractTopiaEntity implements Configuration {

    /**
     * size in bytes
     * Nom de l'attribut en BD : emailMaxSize
     */
    protected long emailMaxSize;

    /**
     * Nom de l'attribut en BD : searchDisplayColumns
     */
    protected List<MailField> searchDisplayColumns;

    /**
     * Nom de l'attribut en BD : invalidFormDisabledActions
     */
    protected EnumSet<MailAction> invalidFormDisabledActions;

    /**
     * Nom de l'attribut en BD : extensionCommands
     */
    protected Collection<ExtensionCommand> extensionCommands;

    /**
     * Nom de l'attribut en BD : chefs
     */
    protected Collection<GroupChef> chefs;

    private static final long serialVersionUID = 4122259729876739426L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_EMAIL_MAX_SIZE, long.class, emailMaxSize);
        visitor.visit(this, PROPERTY_SEARCH_DISPLAY_COLUMNS, List.class, searchDisplayColumns);
        visitor.visit(this, PROPERTY_INVALID_FORM_DISABLED_ACTIONS, EnumSet.class, invalidFormDisabledActions);
        visitor.visit(this, PROPERTY_EXTENSION_COMMANDS, Collection.class, ExtensionCommand.class, extensionCommands);
        visitor.visit(this, PROPERTY_CHEFS, Collection.class, GroupChef.class, chefs);
    }

    @Override
    public void setEmailMaxSize(long emailMaxSize) {
        this.emailMaxSize = emailMaxSize;
    }

    @Override
    public long getEmailMaxSize() {
        long result = this.emailMaxSize;
        return result;
    }

    @Override
    public void setSearchDisplayColumns(List<MailField> searchDisplayColumns) {
        this.searchDisplayColumns = searchDisplayColumns;
    }

    @Override
    public List<MailField> getSearchDisplayColumns() {
        List<MailField> result = this.searchDisplayColumns;
        return result;
    }

    @Override
    public void setInvalidFormDisabledActions(EnumSet<MailAction> invalidFormDisabledActions) {
        this.invalidFormDisabledActions = invalidFormDisabledActions;
    }

    @Override
    public EnumSet<MailAction> getInvalidFormDisabledActions() {
        EnumSet<MailAction> result = this.invalidFormDisabledActions;
        return result;
    }

    @Override
    public void addExtensionCommands(ExtensionCommand extensionCommands) {
        if (this.extensionCommands == null) {
            this.extensionCommands = new LinkedList<ExtensionCommand>();
        }
        this.extensionCommands.add(extensionCommands);
    }

    @Override
    public void addAllExtensionCommands(Collection<ExtensionCommand> extensionCommands) {
        if (extensionCommands == null) {
            return;
        }
        for (ExtensionCommand item : extensionCommands) {
            addExtensionCommands(item);
        }
    }

    @Override
    public void setExtensionCommands(Collection<ExtensionCommand> extensionCommands) {
        this.extensionCommands = extensionCommands;
    }

    @Override
    public void removeExtensionCommands(ExtensionCommand extensionCommands) {
        if (this.extensionCommands == null || !this.extensionCommands.remove(extensionCommands)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearExtensionCommands() {
        if (this.extensionCommands == null) {
            return;
        }
        this.extensionCommands.clear();
    }

    @Override
    public Collection<ExtensionCommand> getExtensionCommands() {
        return extensionCommands;
    }

    @Override
    public ExtensionCommand getExtensionCommandsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(extensionCommands, topiaId);
    }

    @Override
    public Collection<String> getExtensionCommandsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.ExtensionCommand> tmp = getExtensionCommands();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeExtensionCommands() {
        if (extensionCommands == null) {
            return 0;
        }
        return extensionCommands.size();
    }

    @Override
    public boolean isExtensionCommandsEmpty() {
        int size = sizeExtensionCommands();
        return size == 0;
    }

    @Override
    public boolean isExtensionCommandsNotEmpty() {
        boolean empty = isExtensionCommandsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsExtensionCommands(ExtensionCommand extensionCommands) {
        boolean contains = this.extensionCommands !=null && this.extensionCommands.contains(extensionCommands);
        return contains;
    }

    @Override
    public void addChefs(GroupChef chefs) {
        if (this.chefs == null) {
            this.chefs = new LinkedList<GroupChef>();
        }
        this.chefs.add(chefs);
    }

    @Override
    public void addAllChefs(Collection<GroupChef> chefs) {
        if (chefs == null) {
            return;
        }
        for (GroupChef item : chefs) {
            addChefs(item);
        }
    }

    @Override
    public void setChefs(Collection<GroupChef> chefs) {
        this.chefs = chefs;
    }

    @Override
    public void removeChefs(GroupChef chefs) {
        if (this.chefs == null || !this.chefs.remove(chefs)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearChefs() {
        if (this.chefs == null) {
            return;
        }
        this.chefs.clear();
    }

    @Override
    public Collection<GroupChef> getChefs() {
        return chefs;
    }

    @Override
    public GroupChef getChefsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(chefs, topiaId);
    }

    @Override
    public Collection<String> getChefsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.GroupChef> tmp = getChefs();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeChefs() {
        if (chefs == null) {
            return 0;
        }
        return chefs.size();
    }

    @Override
    public boolean isChefsEmpty() {
        int size = sizeChefs();
        return size == 0;
    }

    @Override
    public boolean isChefsNotEmpty() {
        boolean empty = isChefsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsChefs(GroupChef chefs) {
        boolean contains = this.chefs !=null && this.chefs.contains(chefs);
        return contains;
    }

} //ConfigurationAbstract
