package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu May 07 10:55:34 UTC 2015")
public abstract class GeneratedExtensionCommandTopiaDao<E extends ExtensionCommand> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) ExtensionCommand.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.ExtensionCommand;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String extension) {
        return forNaturalId(extension).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String extension) {
        return forNaturalId(extension).exists();
    }

    public E createByNaturalId(String extension) {
        return create(ExtensionCommand.PROPERTY_EXTENSION, extension);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String extension) {
        return forProperties(ExtensionCommand.PROPERTY_EXTENSION, extension);
    }

    public E createByNotNull(String extension) {
        return create(ExtensionCommand.PROPERTY_EXTENSION, extension);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExtensionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ExtensionCommand.PROPERTY_EXTENSION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExtensionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ExtensionCommand.PROPERTY_EXTENSION, v);
        return result;
    }

    @Deprecated
    public E findByExtension(String v) {
        return forExtensionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExtension(String v) {
        return forExtensionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOpenAttachmentCommandIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ExtensionCommand.PROPERTY_OPEN_ATTACHMENT_COMMAND, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOpenAttachmentCommandEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ExtensionCommand.PROPERTY_OPEN_ATTACHMENT_COMMAND, v);
        return result;
    }

    @Deprecated
    public E findByOpenAttachmentCommand(String v) {
        return forOpenAttachmentCommandEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOpenAttachmentCommand(String v) {
        return forOpenAttachmentCommandEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConvertToPdfCommandIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ExtensionCommand.PROPERTY_CONVERT_TO_PDF_COMMAND, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConvertToPdfCommandEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ExtensionCommand.PROPERTY_CONVERT_TO_PDF_COMMAND, v);
        return result;
    }

    @Deprecated
    public E findByConvertToPdfCommand(String v) {
        return forConvertToPdfCommandEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByConvertToPdfCommand(String v) {
        return forConvertToPdfCommandEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Configuration.class) {
            ConfigurationTopiaDao dao =
                topiaDaoSupplier.getDao(Configuration.class, ConfigurationTopiaDao.class);
            tmp = dao.forExtensionCommandsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Configuration.class, entity);
        if (!list.isEmpty()) {
            result.put(Configuration.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedExtensionCommandTopiaDao<E extends ExtensionCommand>
