package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2016 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Jan 22 16:30:47 CET 2016")
public abstract class GeneratedEmailAccountTopiaDao<E extends EmailAccount> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) EmailAccount.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.EmailAccount;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String host, String login, EmailProtocol protocol) {
        return forNaturalId(host, login, protocol).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String host, String login, EmailProtocol protocol) {
        return forNaturalId(host, login, protocol).exists();
    }

    public E createByNaturalId(String host, String login, EmailProtocol protocol) {
        return create(EmailAccount.PROPERTY_HOST, host, EmailAccount.PROPERTY_LOGIN, login, EmailAccount.PROPERTY_PROTOCOL, protocol);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String host, String login, EmailProtocol protocol) {
        return forProperties(EmailAccount.PROPERTY_HOST, host, EmailAccount.PROPERTY_LOGIN, login, EmailAccount.PROPERTY_PROTOCOL, protocol);
    }

    public E createByNotNull(String host, String login, EmailProtocol protocol) {
        return create(EmailAccount.PROPERTY_HOST, host, EmailAccount.PROPERTY_LOGIN, login, EmailAccount.PROPERTY_PROTOCOL, protocol);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHostIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_HOST, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHostEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_HOST, v);
        return result;
    }

    @Deprecated
    public E findByHost(String v) {
        return forHostEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHost(String v) {
        return forHostEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_LOGIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLoginEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_LOGIN, v);
        return result;
    }

    @Deprecated
    public E findByLogin(String v) {
        return forLoginEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLogin(String v) {
        return forLoginEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_PASSWORD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_PASSWORD, v);
        return result;
    }

    @Deprecated
    public E findByPassword(String v) {
        return forPasswordEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPassword(String v) {
        return forPasswordEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPortIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_PORT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPortEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_PORT, v);
        return result;
    }

    @Deprecated
    public E findByPort(int v) {
        return forPortEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPort(int v) {
        return forPortEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectAllowedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_REJECT_ALLOWED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRejectAllowedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_REJECT_ALLOWED, v);
        return result;
    }

    @Deprecated
    public E findByRejectAllowed(boolean v) {
        return forRejectAllowedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRejectAllowed(boolean v) {
        return forRejectAllowedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxAccountTypeIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_FAX_ACCOUNT_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFaxAccountTypeEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_FAX_ACCOUNT_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByFaxAccountType(boolean v) {
        return forFaxAccountTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFaxAccountType(boolean v) {
        return forFaxAccountTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocolIn(Collection<EmailProtocol> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EmailAccount.PROPERTY_PROTOCOL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocolEquals(EmailProtocol v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EmailAccount.PROPERTY_PROTOCOL, v);
        return result;
    }

    @Deprecated
    public E findByProtocol(EmailProtocol v) {
        return forProtocolEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocol(EmailProtocol v) {
        return forProtocolEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEmailAccountTopiaDao<E extends EmailAccount>
