package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Wed Nov 04 16:44:52 CET 2015")
public abstract class GeneratedGroupChefTopiaDao<E extends GroupChef> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GroupChef.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.GroupChef;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(FaxToMailUserGroup userGroup) {
        return create(GroupChef.PROPERTY_USER_GROUP, userGroup);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forManagedUsersContains(FaxToMailUser v) {
        return forContains(GroupChef.PROPERTY_MANAGED_USERS, v);
    }

    @Deprecated
    public E findContainsManagedUsers(FaxToMailUser v) {
        return forManagedUsersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsManagedUsers(FaxToMailUser v) {
        return forManagedUsersContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forManagedGroupsContains(FaxToMailUserGroup v) {
        return forContains(GroupChef.PROPERTY_MANAGED_GROUPS, v);
    }

    @Deprecated
    public E findContainsManagedGroups(FaxToMailUserGroup v) {
        return forManagedGroupsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsManagedGroups(FaxToMailUserGroup v) {
        return forManagedGroupsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUserGroupIn(Collection<FaxToMailUserGroup> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GroupChef.PROPERTY_USER_GROUP, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUserGroupEquals(FaxToMailUserGroup v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GroupChef.PROPERTY_USER_GROUP, v);
        return result;
    }

    @Deprecated
    public E findByUserGroup(FaxToMailUserGroup v) {
        return forUserGroupEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUserGroup(FaxToMailUserGroup v) {
        return forUserGroupEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Configuration.class) {
            ConfigurationTopiaDao dao =
                topiaDaoSupplier.getDao(Configuration.class, ConfigurationTopiaDao.class);
            tmp = dao.forChefsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Configuration.class, entity);
        if (!list.isEmpty()) {
            result.put(Configuration.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGroupChefTopiaDao<E extends GroupChef>
