package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Fri Oct 30 16:29:40 CET 2015")
public abstract class GeneratedMailFilterTopiaDao<E extends MailFilter> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) MailFilter.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.MailFilter;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String expression) {
        return forNaturalId(expression).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String expression) {
        return forNaturalId(expression).exists();
    }

    public E createByNaturalId(String expression) {
        return create(MailFilter.PROPERTY_EXPRESSION, expression);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String expression) {
        return forProperties(MailFilter.PROPERTY_EXPRESSION, expression);
    }

    public E createByNotNull(String expression, MailFolder mailFolder) {
        return create(MailFilter.PROPERTY_EXPRESSION, expression, MailFilter.PROPERTY_MAIL_FOLDER, mailFolder);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExpressionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFilter.PROPERTY_EXPRESSION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExpressionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFilter.PROPERTY_EXPRESSION, v);
        return result;
    }

    @Deprecated
    public E findByExpression(String v) {
        return forExpressionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExpression(String v) {
        return forExpressionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPositionIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFilter.PROPERTY_POSITION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPositionEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFilter.PROPERTY_POSITION, v);
        return result;
    }

    @Deprecated
    public E findByPosition(int v) {
        return forPositionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPosition(int v) {
        return forPositionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilterFolderPriorityIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFilter.PROPERTY_FILTER_FOLDER_PRIORITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFilterFolderPriorityEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFilter.PROPERTY_FILTER_FOLDER_PRIORITY, v);
        return result;
    }

    @Deprecated
    public E findByFilterFolderPriority(boolean v) {
        return forFilterFolderPriorityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFilterFolderPriority(boolean v) {
        return forFilterFolderPriorityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailFolderIn(Collection<MailFolder> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MailFilter.PROPERTY_MAIL_FOLDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailFolderEquals(MailFolder v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MailFilter.PROPERTY_MAIL_FOLDER, v);
        return result;
    }

    @Deprecated
    public E findByMailFolder(MailFolder v) {
        return forMailFolderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMailFolder(MailFolder v) {
        return forMailFolderEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMailFilterTopiaDao<E extends MailFilter>
