/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import java.io.IOException;

public class AdditionalPropertiesDeserializer
extends JsonDeserializer<ObjectSchema.AdditionalProperties> {
    public ObjectSchema.AdditionalProperties deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasCurrentToken()) {
            switch (p.getCurrentTokenId()) {
                case 9: {
                    return null;
                }
                case 10: {
                    return ObjectSchema.NoAdditionalProperties.instance;
                }
                case 1: 
                case 2: 
                case 5: {
                    JsonSchema innerSchema = (JsonSchema)ctxt.readValue(p, JsonSchema.class);
                    return new ObjectSchema.SchemaAdditionalProperties(innerSchema);
                }
            }
        }
        ctxt.reportMappingException("additionalProperties nodes can only be of type boolean or object, got token of type: %s", new Object[]{p.getCurrentToken()});
        return null;
    }
}

