/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.model;

import com.docusign.maestro.model.WorkflowStepErrorError;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Workflow Step History Error")
public class WorkflowStepError
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="code")
    private String code = null;
    @JsonProperty(value="endTime")
    private String endTime = null;
    @JsonProperty(value="error")
    private WorkflowStepErrorError error = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="startTime")
    private String startTime = null;

    public WorkflowStepError code(String code) {
        this.code = code;
        return this;
    }

    @Schema(description="Error code message")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public WorkflowStepError endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(description="Track the End time of the error retry/processed")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public WorkflowStepError error(WorkflowStepErrorError error) {
        this.error = error;
        return this;
    }

    @Schema(description="")
    public WorkflowStepErrorError getError() {
        return this.error;
    }

    public void setError(WorkflowStepErrorError error) {
        this.error = error;
    }

    public WorkflowStepError name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The workflow step name where the error occurred")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowStepError startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="Track Start time of the error occurred")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowStepError workflowStepError = (WorkflowStepError)o;
        return Objects.equals(this.code, workflowStepError.code) && Objects.equals(this.endTime, workflowStepError.endTime) && Objects.equals(this.error, workflowStepError.error) && Objects.equals(this.name, workflowStepError.name) && Objects.equals(this.startTime, workflowStepError.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.endTime, this.error, this.name, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowStepError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

