/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.model;

import com.docusign.maestro.model.DSWorkflowTrigger;
import com.docusign.maestro.model.Participant;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="A DS workflow definition.")
public class WorkflowDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="createdByName")
    private String createdByName = null;
    @JsonProperty(value="documentVersion")
    private String documentVersion = null;
    @JsonProperty(value="participants")
    private Map<String, Participant> participants = null;
    @JsonProperty(value="schemaVersion")
    private String schemaVersion = null;
    @JsonProperty(value="steps")
    private List<Object> steps = new ArrayList<Object>();
    @JsonProperty(value="trigger")
    private DSWorkflowTrigger trigger = null;
    @JsonProperty(value="variables")
    private Map<String, Object> variables = new HashMap<String, Object>();
    @JsonProperty(value="workflowDescription")
    private String workflowDescription = null;
    @JsonProperty(value="workflowName")
    private String workflowName = null;

    public WorkflowDefinition accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(required=true, description="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public WorkflowDefinition createdByName(String createdByName) {
        this.createdByName = createdByName;
        return this;
    }

    @Schema(description="The name of the user who created this workflow definition")
    public String getCreatedByName() {
        return this.createdByName;
    }

    public void setCreatedByName(String createdByName) {
        this.createdByName = createdByName;
    }

    public WorkflowDefinition documentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
        return this;
    }

    @Schema(required=true, description="")
    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public WorkflowDefinition participants(Map<String, Participant> participants) {
        this.participants = participants;
        return this;
    }

    public WorkflowDefinition putParticipantsItem(String key, Participant participantsItem) {
        if (this.participants == null) {
            this.participants = new HashMap<String, Participant>();
        }
        this.participants.put(key, participantsItem);
        return this;
    }

    @Schema(description="A DS Workflow participant record")
    public Map<String, Participant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(Map<String, Participant> participants) {
        this.participants = participants;
    }

    public WorkflowDefinition schemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @Schema(required=true, description="")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public WorkflowDefinition steps(List<Object> steps) {
        this.steps = steps;
        return this;
    }

    public WorkflowDefinition addStepsItem(Object stepsItem) {
        this.steps.add(stepsItem);
        return this;
    }

    @Schema(required=true, description="A list of #/definitions/DSWorkflowStep. Each element is: A DS Workflow Step. This object should be any of the following object models: [#/definitions/DSServiceStep, #/definitions/DSTransformationStep, #/definitions/DSDocGenStep, #/definitions/DSSignStep]")
    public List<Object> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Object> steps) {
        this.steps = steps;
    }

    public WorkflowDefinition trigger(DSWorkflowTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    @Schema(required=true, description="")
    public DSWorkflowTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(DSWorkflowTrigger trigger) {
        this.trigger = trigger;
    }

    public WorkflowDefinition variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public WorkflowDefinition putVariablesItem(String key, Object variablesItem) {
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(required=true, description="A DS Workflow variable record")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public WorkflowDefinition workflowDescription(String workflowDescription) {
        this.workflowDescription = workflowDescription;
        return this;
    }

    @Schema(required=true, description="")
    public String getWorkflowDescription() {
        return this.workflowDescription;
    }

    public void setWorkflowDescription(String workflowDescription) {
        this.workflowDescription = workflowDescription;
    }

    public WorkflowDefinition workflowName(String workflowName) {
        this.workflowName = workflowName;
        return this;
    }

    @Schema(required=true, description="")
    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)o;
        return Objects.equals(this.accountId, workflowDefinition.accountId) && Objects.equals(this.createdByName, workflowDefinition.createdByName) && Objects.equals(this.documentVersion, workflowDefinition.documentVersion) && Objects.equals(this.participants, workflowDefinition.participants) && Objects.equals(this.schemaVersion, workflowDefinition.schemaVersion) && Objects.equals(this.steps, workflowDefinition.steps) && Objects.equals(this.trigger, workflowDefinition.trigger) && Objects.equals(this.variables, workflowDefinition.variables) && Objects.equals(this.workflowDescription, workflowDefinition.workflowDescription) && Objects.equals(this.workflowName, workflowDefinition.workflowName);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.createdByName, this.documentVersion, this.participants, this.schemaVersion, this.steps, this.trigger, this.variables, this.workflowDescription, this.workflowName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowDefinition {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    createdByName: ").append(this.toIndentedString(this.createdByName)).append("\n");
        sb.append("    documentVersion: ").append(this.toIndentedString(this.documentVersion)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    schemaVersion: ").append(this.toIndentedString(this.schemaVersion)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString(this.trigger)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    workflowDescription: ").append(this.toIndentedString(this.workflowDescription)).append("\n");
        sb.append("    workflowName: ").append(this.toIndentedString(this.workflowName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

