/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.maestro.api;

import com.docusign.maestro.client.ApiClient;
import com.docusign.maestro.client.ApiException;
import com.docusign.maestro.client.ApiResponse;
import com.docusign.maestro.client.Configuration;
import com.docusign.maestro.client.Pair;
import com.docusign.maestro.model.TriggerPayload;
import com.docusign.maestro.model.TriggerWorkflowViaPostResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class WorkflowTriggerApi {
    private ApiClient apiClient;

    public WorkflowTriggerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTriggerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TriggerWorkflowViaPostResponse triggerWorkflow(String accountId, String workflowDefinitionId, TriggerPayload body) throws ApiException {
        return this.triggerWorkflow(accountId, workflowDefinitionId, body, null);
    }

    public TriggerWorkflowViaPostResponse triggerWorkflow(String accountId, String workflowDefinitionId, TriggerPayload body, TriggerWorkflowOptions options) throws ApiException {
        ApiResponse<TriggerWorkflowViaPostResponse> localVarResponse = this.triggerWorkflowWithHttpInfo(accountId, workflowDefinitionId, body, options);
        return localVarResponse.getData();
    }

    public ApiResponse<TriggerWorkflowViaPostResponse> triggerWorkflowWithHttpInfo(String accountId, String workflowDefinitionId, TriggerPayload body, TriggerWorkflowOptions options) throws ApiException {
        TriggerPayload localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling triggerWorkflow");
        }
        if (workflowDefinitionId == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowDefinitionId' when calling triggerWorkflow");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling triggerWorkflow");
        }
        String localVarPath = "/v1/accounts/{accountId}/workflow_definitions/{workflowDefinitionId}/trigger".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workflowDefinitionId\\}", this.apiClient.escapeString(workflowDefinitionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mtid", options.mtid));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mtsec", options.mtsec));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<TriggerWorkflowViaPostResponse> localVarReturnType = new GenericType<TriggerWorkflowViaPostResponse>(){};
        TriggerWorkflowViaPostResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<TriggerWorkflowViaPostResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class TriggerWorkflowOptions {
        private String mtid = null;
        private String mtsec = null;

        public void setMtid(String mtid) {
            this.mtid = mtid;
        }

        public String getMtid() {
            return this.mtid;
        }

        public void setMtsec(String mtsec) {
            this.mtsec = mtsec;
        }

        public String getMtsec() {
            return this.mtsec;
        }
    }
}

