/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Clock;
import com.datastax.driver.core.Native;
import com.datastax.driver.core.NativeClock;
import com.datastax.driver.core.SystemClock;
import com.datastax.driver.core.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClockFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClockFactory.class);
    private static final String USE_NATIVE_CLOCK_SYSTEM_PROPERTY = "com.datastax.driver.USE_NATIVE_CLOCK";

    ClockFactory() {
    }

    static Clock newInstance() {
        if (Native.isGettimeofdayAvailable() && SystemProperties.getBoolean(USE_NATIVE_CLOCK_SYSTEM_PROPERTY, true)) {
            LOGGER.info("Using native clock to generate timestamps.");
            return new NativeClock();
        }
        LOGGER.info("Using java.lang.System clock to generate timestamps.");
        return new SystemClock();
    }
}

