/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class NoHostAvailableException
extends DriverException {
    private static final long serialVersionUID = 0L;
    private final Map<InetAddress, String> errors;

    public NoHostAvailableException(Map<InetAddress, String> errors) {
        super(NoHostAvailableException.makeMessage(errors));
        this.errors = errors;
    }

    private NoHostAvailableException(String message, Throwable cause, Map<InetAddress, String> errors) {
        super(message, cause);
        this.errors = errors;
    }

    public Map<InetAddress, String> getErrors() {
        return new HashMap<InetAddress, String>(this.errors);
    }

    @Override
    public DriverException copy() {
        return new NoHostAvailableException(this.getMessage(), this, this.errors);
    }

    private static String makeMessage(Map<InetAddress, String> errors) {
        if (errors.size() == 0) {
            return "All host(s) tried for query failed (no host was tried)";
        }
        if (errors.size() <= 3) {
            StringBuilder sb = new StringBuilder();
            sb.append("All host(s) tried for query failed (tried: ");
            int n = 0;
            for (Map.Entry<InetAddress, String> entry : errors.entrySet()) {
                if (n++ > 0) {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append(" (").append(entry.getValue()).append(")");
            }
            return sb.append(")").toString();
        }
        return String.format("All host(s) tried for query failed (tried: %s - use getErrors() for details)", errors.keySet());
    }
}

