/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.service;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboMultiReader;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class BoboService {
    private static Logger logger = Logger.getLogger(BoboService.class);
    private final File _idxDir;
    private BoboMultiReader _boboReader;

    public BoboService(String path) {
        this(new File(path));
    }

    public BoboService(File idxDir) {
        this._idxDir = idxDir;
        this._boboReader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowseResult browse(BrowseRequest req) {
        BoboBrowser browser = null;
        try {
            browser = new BoboBrowser(this._boboReader);
            BrowseResult browseResult = browser.browse(req);
            return browseResult;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            BrowseResult browseResult = new BrowseResult();
            return browseResult;
        }
        finally {
            if (browser != null) {
                try {
                    browser.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    public void start() throws IOException {
        block2: {
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((File)this._idxDir));
            try {
                this._boboReader = BoboMultiReader.getInstance(reader);
            }
            catch (IOException ioe) {
                if (reader == null) break block2;
                reader.close();
            }
        }
    }

    public void shutdown() {
        if (this._boboReader != null) {
            try {
                this._boboReader.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

