/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.AbstractTerminalNode;
import com.browseengine.bobo.search.section.IntMetaDataCache;
import com.browseengine.bobo.search.section.MetaDataCache;
import com.browseengine.bobo.search.section.MetaDataQuery;
import com.browseengine.bobo.search.section.SectionSearchQueryPlan;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;

public class IntMetaDataQuery
extends MetaDataQuery {
    private final Validator _validator;

    public IntMetaDataQuery(Term term, Validator validator) {
        super(term);
        this._validator = validator;
    }

    public String toString(String field) {
        return "IntMetaDataQuery(" + this._validator.toString() + ")";
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    @Override
    public SectionSearchQueryPlan getPlan(AtomicReader reader) throws IOException {
        return new IntMetaDataNodeNoCache(this._term, reader, this._validator);
    }

    @Override
    public SectionSearchQueryPlan getPlan(MetaDataCache cache) throws IOException {
        return new IntMetaDataNode((IntMetaDataCache)cache, this._validator);
    }

    public static class IntMetaDataNode
    extends SectionSearchQueryPlan {
        private final IntMetaDataCache _cache;
        private final Validator _validator;
        private final int _maxDoc;
        private int _maxSec;

        public IntMetaDataNode(IntMetaDataCache cache, Validator validator) throws IOException {
            this._cache = cache;
            this._maxDoc = cache.maxDoc();
            this._validator = validator;
        }

        @Override
        public int fetchDoc(int targetDoc) throws IOException {
            if (this._curDoc == Integer.MAX_VALUE) {
                return this._curDoc;
            }
            if (targetDoc <= this._curDoc) {
                targetDoc = this._curDoc + 1;
            }
            this._curSec = -1;
            while (targetDoc < this._maxDoc) {
                this._maxSec = this._cache.getNumItems(targetDoc);
                if (this._maxSec <= 0) {
                    ++targetDoc;
                    continue;
                }
                this._curDoc = targetDoc;
                return this._curDoc;
            }
            this._curDoc = Integer.MAX_VALUE;
            return this._curDoc;
        }

        @Override
        public int fetchSec(int targetSec) throws IOException {
            if (this._curSec == Integer.MAX_VALUE) {
                return this._curSec;
            }
            if (targetSec <= this._curSec) {
                targetSec = this._curSec + 1;
            }
            while (targetSec < this._maxSec) {
                int datum = this._cache.getValue(this._curDoc, targetSec, 0);
                if (this._validator.validate(datum)) {
                    this._curSec = targetSec;
                    return this._curSec;
                }
                ++targetSec;
            }
            this._curSec = Integer.MAX_VALUE;
            return this._curSec;
        }
    }

    public static class IntMetaDataNodeNoCache
    extends AbstractTerminalNode {
        private final Validator _validator;
        private byte[] _data;
        private int _dataLen;

        public IntMetaDataNodeNoCache(Term term, AtomicReader reader, Validator validator) throws IOException {
            super(term, reader);
            this._validator = validator;
        }

        @Override
        public int fetchDoc(int targetDoc) throws IOException {
            this._dataLen = -1;
            return super.fetchDoc(targetDoc);
        }

        @Override
        public int fetchSec(int targetSec) throws IOException {
            if (this._curSec == Integer.MAX_VALUE) {
                return this._curSec;
            }
            if (targetSec <= this._curSec) {
                targetSec = this._curSec + 1;
            }
            if (this._dataLen == -1 && this._posLeft > 0) {
                this._dp.nextPosition();
                BytesRef payload = this._dp.getPayload();
                if (payload != null) {
                    this._dataLen = payload.length;
                    this._data = payload.bytes;
                }
            }
            int offset = targetSec * 4;
            while (offset + 4 <= this._dataLen) {
                int datum = this._data[offset] & 0xFF | (this._data[offset + 1] & 0xFF) << 8 | (this._data[offset + 2] & 0xFF) << 16 | (this._data[offset + 3] & 0xFF) << 24;
                if (this._validator.validate(datum)) {
                    this._curSec = targetSec;
                    return this._curSec;
                }
                offset = ++targetSec * 4;
            }
            this._curSec = Integer.MAX_VALUE;
            return this._curSec;
        }
    }

    public static class SimpleRangeValidator
    extends Validator {
        private final int _lower;
        private final int _upper;

        public SimpleRangeValidator(int lower, int upper) {
            this._lower = lower;
            this._upper = upper;
        }

        @Override
        public boolean validate(int datum) {
            return datum >= this._lower && datum <= this._upper;
        }

        public String toString() {
            return "RangeValidator[" + this._lower + "," + this._upper + "]";
        }
    }

    public static class SimpleValueValidator
    extends Validator {
        private final int _val;

        public SimpleValueValidator(int val) {
            this._val = val;
        }

        @Override
        public boolean validate(int datum) {
            return datum == this._val;
        }

        public String toString() {
            return "SingleValueValidator[" + this._val + "]";
        }
    }

    public static abstract class Validator {
        public abstract boolean validate(int var1);
    }
}

