/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query;

import com.browseengine.bobo.query.ScorerBuilder;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class ScoreAdjusterQuery
extends Query {
    protected final Query _query;
    protected final ScorerBuilder _scorerBuilder;

    public ScoreAdjusterQuery(Query query, ScorerBuilder scorerBuilder) {
        this._query = query;
        this._scorerBuilder = scorerBuilder;
    }

    public void extractTerms(Set terms) {
        this._query.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new ScoreAdjusterWeight(this._query.createWeight(searcher));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        this._query.rewrite(reader);
        return this;
    }

    public String toString(String field) {
        return this._query.toString(field);
    }

    private class ScoreAdjusterWeight
    extends Weight {
        Weight _innerWeight;

        public ScoreAdjusterWeight(Weight innerWeight) throws IOException {
            this._innerWeight = innerWeight;
        }

        public String toString() {
            return "weight(" + (Object)((Object)ScoreAdjusterQuery.this) + ")";
        }

        public Query getQuery() {
            return this._innerWeight.getQuery();
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer innerScorer = this._innerWeight.scorer(context, scoreDocsInOrder, topScorer, acceptDocs);
            return ScoreAdjusterQuery.this._scorerBuilder.createScorer(innerScorer, context.reader(), scoreDocsInOrder, topScorer);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation innerExplain = this._innerWeight.explain(context, doc);
            return ScoreAdjusterQuery.this._scorerBuilder.explain(context.reader(), doc, innerExplain);
        }

        public float getValueForNormalization() throws IOException {
            return this._innerWeight.getValueForNormalization();
        }

        public void normalize(float norm, float topLevelBoost) {
            this._innerWeight.normalize(norm, topLevelBoost);
        }
    }
}

