/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.ComparatorFactory;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.FieldValueAccessor;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.facets.impl.FacetHitcountComparatorFactory;
import com.browseengine.bobo.facets.impl.SimpleFacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.IntBoundedPriorityQueue;
import com.browseengine.bobo.util.LazyBigIntArray;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.search.ScoreDoc;

public class SimpleGroupbyFacetHandler
extends FacetHandler<FacetHandler.FacetDataNone> {
    private final LinkedHashSet<String> _fieldsSet;
    private ArrayList<SimpleFacetHandler> _facetHandlers;
    private Map<String, SimpleFacetHandler> _facetHandlerMap;
    private static final String SEP = ",";
    private final String _sep;

    public SimpleGroupbyFacetHandler(String name, LinkedHashSet<String> dependsOn, String separator) {
        super(name, dependsOn);
        this._fieldsSet = dependsOn;
        this._facetHandlers = null;
        this._facetHandlerMap = null;
        this._sep = separator;
    }

    public SimpleGroupbyFacetHandler(String name, LinkedHashSet<String> dependsOn) {
        this(name, dependsOn, SEP);
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties selectionProperty) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>();
        String[] vals = value.split(this._sep);
        for (int i = 0; i < vals.length; ++i) {
            SimpleFacetHandler handler = this._facetHandlers.get(i);
            BrowseSelection sel = new BrowseSelection(handler.getName());
            sel.addValue(vals[i]);
            filterList.add(handler.buildFilter(sel));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec fspec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboSegmentReader reader, int docBase) {
                ArrayList<DefaultFacetCountCollector> collectorList = new ArrayList<DefaultFacetCountCollector>(SimpleGroupbyFacetHandler.this._facetHandlers.size());
                for (SimpleFacetHandler facetHandler : SimpleGroupbyFacetHandler.this._facetHandlers) {
                    collectorList.add((DefaultFacetCountCollector)facetHandler.getFacetCountCollectorSource(sel, fspec).getFacetCountCollector(reader, docBase));
                }
                return new GroupbyFacetCountCollector(SimpleGroupbyFacetHandler.this._name, fspec, collectorList.toArray(new DefaultFacetCountCollector[collectorList.size()]), reader.maxDoc(), SimpleGroupbyFacetHandler.this._sep);
            }
        };
    }

    @Override
    public String[] getFieldValues(BoboSegmentReader reader, int id) {
        ArrayList<String> valList = new ArrayList<String>();
        for (SimpleFacetHandler handler : this._facetHandlers) {
            StringBuffer buf = new StringBuffer();
            boolean firsttime = true;
            String[] vals = ((FacetHandler)handler).getFieldValues(reader, id);
            if (vals != null && vals.length > 0) {
                if (!firsttime) {
                    buf.append(SEP);
                } else {
                    firsttime = false;
                }
                for (String val : vals) {
                    buf.append(val);
                }
            }
            valList.add(buf.toString());
        }
        return valList.toArray(new String[valList.size()]);
    }

    @Override
    public Object[] getRawFieldValues(BoboSegmentReader reader, int id) {
        return this.getFieldValues(reader, id);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new DocComparatorSource(){

            @Override
            public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
                ArrayList<DocComparator> comparatorList = new ArrayList<DocComparator>(SimpleGroupbyFacetHandler.this._fieldsSet.size());
                for (SimpleFacetHandler handler : SimpleGroupbyFacetHandler.this._facetHandlers) {
                    comparatorList.add(((FacetHandler)handler).getDocComparatorSource().getComparator(reader, docbase));
                }
                return new GroupbyDocComparator(comparatorList.toArray(new DocComparator[comparatorList.size()]));
            }
        };
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboSegmentReader reader) throws IOException {
        this._facetHandlers = new ArrayList(this._fieldsSet.size());
        this._facetHandlerMap = new HashMap<String, SimpleFacetHandler>(this._fieldsSet.size());
        for (String name : this._fieldsSet) {
            FacetHandler<?> handler = reader.getFacetHandler(name);
            if (handler == null || !(handler instanceof SimpleFacetHandler)) {
                throw new IllegalStateException("only simple facet handlers supported");
            }
            SimpleFacetHandler sfh = (SimpleFacetHandler)handler;
            this._facetHandlers.add(sfh);
            this._facetHandlerMap.put(name, sfh);
        }
        return FacetHandler.FacetDataNone.instance;
    }

    private static class GroupbyFacetCountCollector
    implements FacetCountCollector {
        private final DefaultFacetCountCollector[] _subcollectors;
        private final String _name;
        private final FacetSpec _fspec;
        private final BigSegmentedArray _count;
        private final int _countlength;
        private final int[] _lens;
        private final int _maxdoc;
        private final String _sep;

        public GroupbyFacetCountCollector(String name, FacetSpec fspec, DefaultFacetCountCollector[] subcollectors, int maxdoc, String sep) {
            this._name = name;
            this._fspec = fspec;
            this._subcollectors = subcollectors;
            this._sep = sep;
            int totalLen = 1;
            this._lens = new int[this._subcollectors.length];
            for (int i = 0; i < this._subcollectors.length; ++i) {
                this._lens[i] = this._subcollectors[i]._countlength;
                totalLen *= this._lens[i];
            }
            this._countlength = totalLen;
            this._count = new LazyBigIntArray(this._countlength);
            this._maxdoc = maxdoc;
        }

        @Override
        public final void collect(int docid) {
            int idx = 0;
            int i = 0;
            int segsize = this._countlength;
            for (DefaultFacetCountCollector subcollector : this._subcollectors) {
                idx += subcollector._dataCache.orderArray.get(docid) * (segsize /= this._lens[i++]);
            }
            this._count.add(idx, this._count.get(idx) + 1);
        }

        @Override
        public void collectAll() {
            for (int i = 0; i < this._maxdoc; ++i) {
                this.collect(i);
            }
        }

        @Override
        public BigSegmentedArray getCountDistribution() {
            return this._count;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public BrowseFacet getFacet(String value) {
            String[] vals = value.split(this._sep);
            if (vals.length == 0) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            int startIdx = 0;
            int segLen = this._countlength;
            for (int i = 0; i < vals.length; ++i) {
                if (i > 0) {
                    buf.append(this._sep);
                }
                int index = this._subcollectors[i]._dataCache.valArray.indexOf(vals[i]);
                String facetName = this._subcollectors[i]._dataCache.valArray.get(index);
                buf.append(facetName);
                startIdx += index * (segLen /= this._subcollectors[i]._countlength);
            }
            int count = 0;
            for (int i = startIdx; i < startIdx + segLen; ++i) {
                count += this._count.get(i);
            }
            BrowseFacet f = new BrowseFacet(buf.toString(), count);
            return f;
        }

        @Override
        public int getFacetHitsCount(Object value) {
            String[] vals = ((String)value).split(this._sep);
            if (vals.length == 0) {
                return 0;
            }
            int startIdx = 0;
            int segLen = this._countlength;
            for (int i = 0; i < vals.length; ++i) {
                int index = this._subcollectors[i]._dataCache.valArray.indexOf(vals[i]);
                startIdx += index * (segLen /= this._subcollectors[i]._countlength);
            }
            int count = 0;
            for (int i = startIdx; i < startIdx + segLen; ++i) {
                count += this._count.get(i);
            }
            return count;
        }

        private final String getFacetString(int idx) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            for (int len : this._lens) {
                if (i > 0) {
                    buf.append(this._sep);
                }
                int adjusted = idx * len;
                int bucket = adjusted / this._countlength;
                buf.append(this._subcollectors[i]._dataCache.valArray.get(bucket));
                idx = adjusted % this._countlength;
                ++i;
            }
            return buf.toString();
        }

        private final Object[] getRawFaceValue(int idx) {
            Object[] retVal = new Object[this._lens.length];
            int i = 0;
            for (int len : this._lens) {
                int adjusted = idx * len;
                int bucket = adjusted / this._countlength;
                retVal[i++] = this._subcollectors[i]._dataCache.valArray.getRawValue(bucket);
                idx = adjusted % this._countlength;
            }
            return retVal;
        }

        @Override
        public List<BrowseFacet> getFacets() {
            if (this._fspec != null) {
                AbstractList facetColl;
                FacetSpec.FacetSortSpec sortspec;
                int minCount = this._fspec.getMinHitCount();
                int max = this._fspec.getMaxCount();
                if (max <= 0) {
                    max = this._countlength;
                }
                if ((sortspec = this._fspec.getOrderBy()) == FacetSpec.FacetSortSpec.OrderValueAsc) {
                    facetColl = new ArrayList<BrowseFacet>(max);
                    for (int i = 1; i < this._countlength; ++i) {
                        int hits = this._count.get(i);
                        if (hits >= minCount) {
                            BrowseFacet facet = new BrowseFacet(this.getFacetString(i), hits);
                            facetColl.add((BrowseFacet)facet);
                        }
                        if (facetColl.size() < max) {
                            continue;
                        }
                        break;
                    }
                } else {
                    int val;
                    ComparatorFactory comparatorFactory = sortspec == FacetSpec.FacetSortSpec.OrderHitsDesc ? new FacetHitcountComparatorFactory() : this._fspec.getCustomComparatorFactory();
                    if (comparatorFactory == null) {
                        throw new IllegalArgumentException("facet comparator factory not specified");
                    }
                    IntBoundedPriorityQueue.IntComparator comparator = comparatorFactory.newComparator(new FieldValueAccessor(){

                        @Override
                        public String getFormatedValue(int index) {
                            return GroupbyFacetCountCollector.this.getFacetString(index);
                        }

                        @Override
                        public Object getRawValue(int index) {
                            return GroupbyFacetCountCollector.this.getRawFaceValue(index);
                        }
                    }, this._count);
                    facetColl = new LinkedList();
                    int forbidden = -1;
                    IntBoundedPriorityQueue pq = new IntBoundedPriorityQueue(comparator, max, -1);
                    for (int i = 1; i < this._countlength; ++i) {
                        int hits = this._count.get(i);
                        if (hits < minCount || pq.offer(i)) continue;
                        minCount = hits + 1;
                    }
                    while ((val = pq.pollInt()) != -1) {
                        BrowseFacet facet = new BrowseFacet(this.getFacetString(val), this._count.get(val));
                        ((LinkedList)facetColl).addFirst(facet);
                    }
                }
                return facetColl;
            }
            return FacetCountCollector.EMPTY_FACET_LIST;
        }

        @Override
        public void close() {
        }

        @Override
        public FacetIterator iterator() {
            return new GroupByFacetIterator();
        }

        public class GroupByFacetIterator
        extends FacetIterator {
            private int _index = 0;

            public GroupByFacetIterator() {
                this.facet = null;
                this.count = 0;
            }

            @Override
            public Comparable<?> next() {
                if (this._index >= 0 && !this.hasNext()) {
                    throw new NoSuchElementException("No more facets in this iteration");
                }
                ++this._index;
                this.facet = GroupbyFacetCountCollector.this.getFacetString(this._index);
                this.count = GroupbyFacetCountCollector.this._count.get(this._index);
                return this.facet;
            }

            @Override
            public boolean hasNext() {
                return this._index < GroupbyFacetCountCollector.this._countlength - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
            }

            @Override
            public Comparable<?> next(int minHits) {
                if (this._index >= 0 && !this.hasNext()) {
                    this.count = 0;
                    this.facet = null;
                    return null;
                }
                do {
                    ++this._index;
                } while (this._index < GroupbyFacetCountCollector.this._countlength - 1 && GroupbyFacetCountCollector.this._count.get(this._index) < minHits);
                if (GroupbyFacetCountCollector.this._count.get(this._index) >= minHits) {
                    this.facet = GroupbyFacetCountCollector.this.getFacetString(this._index);
                    this.count = GroupbyFacetCountCollector.this._count.get(this._index);
                } else {
                    this.count = 0;
                    this.facet = null;
                }
                return this.facet;
            }

            @Override
            public String format(Object val) {
                return (String)val;
            }
        }
    }

    private static class GroupbyDocComparator
    extends DocComparator {
        private final DocComparator[] _comparators;

        public GroupbyDocComparator(DocComparator[] comparators) {
            this._comparators = comparators;
        }

        @Override
        public final int compare(ScoreDoc d1, ScoreDoc d2) {
            DocComparator comparator;
            int retval = 0;
            DocComparator[] arr$ = this._comparators;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retval = (comparator = arr$[i$]).compare(d1, d2)) == 0; ++i$) {
            }
            return retval;
        }

        @Override
        public final Comparable<?> value(final ScoreDoc doc) {
            return new Comparable(){

                public int compareTo(Object o) {
                    DocComparator comparator;
                    int retval = 0;
                    DocComparator[] arr$ = GroupbyDocComparator.this._comparators;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (retval = (comparator = arr$[i$]).value(doc).compareTo(o)) == 0; ++i$) {
                    }
                    return retval;
                }
            };
        }
    }
}

