/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.filter.GeoSimpleFacetFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.LazyBigIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GeoSimpleFacetCountCollector
implements FacetCountCollector {
    private static final Logger log = Logger.getLogger((String)GeoSimpleFacetCountCollector.class.getName());
    private final FacetSpec _spec;
    private final String _name;
    private int[] _latCount;
    private int[] _longCount;
    private final BigSegmentedArray _latOrderArray;
    private final FacetDataCache<?> _latDataCache;
    private final TermStringList _predefinedRanges;
    private int[][] _latPredefinedRangeIndexes;
    private final BigSegmentedArray _longOrderArray;
    private final FacetDataCache<?> _longDataCache;
    private int[][] _longPredefinedRangeIndexes;

    protected GeoSimpleFacetCountCollector(String name, FacetDataCache<?> latDataCache, FacetDataCache<?> longDataCache, int docBase, FacetSpec spec, List<String> predefinedRanges) {
        this._name = name;
        this._latDataCache = latDataCache;
        this._longDataCache = longDataCache;
        this._latCount = new int[this._latDataCache.freqs.length];
        this._longCount = new int[this._longDataCache.freqs.length];
        log.info((Object)("latCount: " + this._latDataCache.freqs.length + " longCount: " + this._longDataCache.freqs.length));
        this._latOrderArray = this._latDataCache.orderArray;
        this._longOrderArray = this._longDataCache.orderArray;
        this._spec = spec;
        this._predefinedRanges = new TermStringList();
        Collections.sort(predefinedRanges);
        this._predefinedRanges.addAll((Collection<? extends String>)predefinedRanges);
        if (predefinedRanges != null) {
            this._latPredefinedRangeIndexes = new int[this._predefinedRanges.size()][2];
            this._longPredefinedRangeIndexes = new int[this._predefinedRanges.size()][2];
            int i = 0;
            for (String range : this._predefinedRanges) {
                int[] ranges = GeoSimpleFacetFilter.parse(this._latDataCache, this._longDataCache, range);
                this._latPredefinedRangeIndexes[i][0] = ranges[0];
                this._latPredefinedRangeIndexes[i][1] = ranges[1];
                this._longPredefinedRangeIndexes[i][0] = ranges[2];
                this._longPredefinedRangeIndexes[i][1] = ranges[3];
                ++i;
            }
        }
    }

    @Override
    public void collect(int docid) {
        for (int[] range : this._latPredefinedRangeIndexes) {
            int latValue = this._latOrderArray.get(docid);
            int longValue = this._longOrderArray.get(docid);
            int latStart = range[0];
            int latEnd = range[1];
            if (latValue < latStart || latValue > latEnd) continue;
            for (int[] longRange : this._longPredefinedRangeIndexes) {
                int longStart = longRange[0];
                int longEnd = longRange[1];
                if (longValue < longStart || longValue > longEnd) continue;
                int n = this._latOrderArray.get(docid);
                this._latCount[n] = this._latCount[n] + 1;
                int n2 = this._longOrderArray.get(docid);
                this._longCount[n2] = this._longCount[n2] + 1;
            }
        }
    }

    @Override
    public void collectAll() {
        this._latCount = this._latDataCache.freqs;
        this._longCount = this._longDataCache.freqs;
    }

    @Override
    public BigSegmentedArray getCountDistribution() {
        LazyBigIntArray dist = null;
        if (this._latPredefinedRangeIndexes != null) {
            dist = new LazyBigIntArray(this._latPredefinedRangeIndexes.length);
            int n = 0;
            for (int[] range : this._latPredefinedRangeIndexes) {
                int start = range[0];
                int end = range[1];
                int sum = 0;
                for (int i = start; i < end; ++i) {
                    sum += this._latCount[i];
                }
                ((BigSegmentedArray)dist).add(n++, sum);
            }
        }
        return dist;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public BrowseFacet getFacet(String value) {
        BrowseFacet facet = null;
        int[] range = FacetRangeFilter.parse(this._latDataCache, value);
        if (range != null) {
            int sum = 0;
            for (int i = range[0]; i <= range[1]; ++i) {
                sum += this._latCount[i];
            }
            facet = new BrowseFacet(value, sum);
        }
        return facet;
    }

    @Override
    public int getFacetHitsCount(Object value) {
        int[] range = FacetRangeFilter.parse(this._latDataCache, (String)value);
        if (range != null) {
            int sum = 0;
            for (int i = range[0]; i <= range[1]; ++i) {
                sum += this._latCount[i];
            }
            return sum;
        }
        return 0;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._spec != null) {
            if (this._latPredefinedRangeIndexes != null) {
                int minCount = this._spec.getMinHitCount();
                int[] rangeCounts = new int[this._latPredefinedRangeIndexes.length];
                for (int i = 0; i < this._latCount.length; ++i) {
                    if (this._latCount[i] <= 0) continue;
                    for (int k = 0; k < this._latPredefinedRangeIndexes.length; ++k) {
                        if (i < this._latPredefinedRangeIndexes[k][0] || i > this._latPredefinedRangeIndexes[k][1]) continue;
                        int n = k;
                        rangeCounts[n] = rangeCounts[n] + this._latCount[i];
                    }
                }
                ArrayList<BrowseFacet> list = new ArrayList<BrowseFacet>(rangeCounts.length);
                for (int i = 0; i < rangeCounts.length; ++i) {
                    if (rangeCounts[i] < minCount) continue;
                    BrowseFacet choice = new BrowseFacet();
                    choice.setFacetValueHitCount(rangeCounts[i]);
                    choice.setValue(this._predefinedRanges.get(i));
                    list.add(choice);
                }
                return list;
            }
            return FacetCountCollector.EMPTY_FACET_LIST;
        }
        return FacetCountCollector.EMPTY_FACET_LIST;
    }

    @Override
    public void close() {
    }

    @Override
    public FacetIterator iterator() {
        LazyBigIntArray rangeCounts = new LazyBigIntArray(this._latPredefinedRangeIndexes.length);
        for (int i = 0; i < this._latCount.length; ++i) {
            if (this._latCount[i] <= 0) continue;
            for (int k = 0; k < this._latPredefinedRangeIndexes.length; ++k) {
                if (i < this._latPredefinedRangeIndexes[k][0] || i > this._latPredefinedRangeIndexes[k][1]) continue;
                rangeCounts.add(k, rangeCounts.get(k) + this._latCount[i]);
            }
        }
        return new DefaultFacetIterator(this._predefinedRanges, rangeCounts, rangeCounts.size(), true);
    }
}

