/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.BucketFacetCountCollector;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class BucketFacetHandler
extends FacetHandler<FacetHandler.FacetDataNone> {
    private final Map<String, String[]> _predefinedBuckets;
    private final String _name;
    private final String _dependsOnFacetName;

    public BucketFacetHandler(String name, Map<String, String[]> predefinedBuckets, String dependsOnFacetName) {
        super(name, new HashSet<String>(Arrays.asList(dependsOnFacetName)));
        this._name = name;
        this._predefinedBuckets = predefinedBuckets;
        this._dependsOnFacetName = dependsOnFacetName;
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        return dependOnFacetHandler.getDocComparatorSource();
    }

    @Override
    public String[] getFieldValues(BoboSegmentReader reader, int id) {
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        return dependOnFacetHandler.getFieldValues(reader, id);
    }

    @Override
    public Object[] getRawFieldValues(BoboSegmentReader reader, int id) {
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        return dependOnFacetHandler.getRawFieldValues(reader, id);
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String bucketString, Properties prop) throws IOException {
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        String[] elems = this._predefinedBuckets.get(bucketString);
        if (elems == null || elems.length == 0) {
            return EmptyFilter.getInstance();
        }
        if (elems.length == 1) {
            return dependOnFacetHandler.buildRandomAccessFilter(elems[0], prop);
        }
        return dependOnFacetHandler.buildRandomAccessOrFilter(elems, prop, false);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] bucketStrings, Properties prop) throws IOException {
        LinkedList<RandomAccessFilter> filterList = new LinkedList<RandomAccessFilter>();
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        for (String bucketString : bucketStrings) {
            String[] vals = this._predefinedBuckets.get(bucketString);
            RandomAccessFilter filter = dependOnFacetHandler.buildRandomAccessOrFilter(vals, prop, false);
            if (filter == EmptyFilter.getInstance()) {
                return EmptyFilter.getInstance();
            }
            filterList.add(filter);
        }
        if (filterList.size() == 0) {
            return EmptyFilter.getInstance();
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] bucketStrings, Properties prop, boolean isNot) throws IOException {
        if (isNot) {
            RandomAccessFilter excludeFilter = this.buildRandomAccessAndFilter(bucketStrings, prop);
            return new RandomAccessNotFilter(excludeFilter);
        }
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        HashSet<String> selections = new HashSet<String>();
        for (String bucket : bucketStrings) {
            String[] vals = this._predefinedBuckets.get(bucket);
            if (vals == null) continue;
            for (String val : vals) {
                selections.add(val);
            }
        }
        if (selections != null && selections.size() > 0) {
            String[] sels = selections.toArray(new String[0]);
            if (selections.size() == 1) {
                return dependOnFacetHandler.buildRandomAccessFilter(sels[0], prop);
            }
            return dependOnFacetHandler.buildRandomAccessOrFilter(sels, prop, false);
        }
        return EmptyFilter.getInstance();
    }

    @Override
    public int getNumItems(BoboSegmentReader reader, int id) {
        FacetHandler<?> dependOnFacetHandler = this.getDependedFacetHandler(this._dependsOnFacetName);
        FacetDataCache data = (FacetDataCache)dependOnFacetHandler.getFacetData(reader);
        return data.getNumItems(id);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboSegmentReader reader, int docBase) {
                FacetHandler<?> dependOnFacetHandler = BucketFacetHandler.this.getDependedFacetHandler(BucketFacetHandler.this._dependsOnFacetName);
                FacetCountCollector defaultCollector = dependOnFacetHandler.getFacetCountCollectorSource(sel, ospec).getFacetCountCollector(reader, docBase);
                if (defaultCollector instanceof DefaultFacetCountCollector) {
                    return new BucketFacetCountCollector(BucketFacetHandler.this._name, (DefaultFacetCountCollector)defaultCollector, ospec, BucketFacetHandler.this._predefinedBuckets, reader.numDocs());
                }
                throw new IllegalStateException("dependent facet handler must build " + DefaultFacetCountCollector.class);
            }
        };
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboSegmentReader reader) throws IOException {
        return FacetHandler.FacetDataNone.instance;
    }
}

