/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigNestedIntArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

public class MultiValueORFacetFilter
extends RandomAccessFilter {
    private final FacetHandler<?> _facetHandler;
    private final String[] _vals;
    private final boolean _takeCompliment;
    private final FacetValueConverter _valueConverter;

    public MultiValueORFacetFilter(FacetHandler<?> facetHandler, String[] vals, boolean takeCompliment) {
        this(facetHandler, vals, FacetValueConverter.DEFAULT, takeCompliment);
    }

    public MultiValueORFacetFilter(FacetHandler<?> facetHandler, String[] vals, FacetValueConverter valueConverter, boolean takeCompliment) {
        this._facetHandler = facetHandler;
        this._vals = vals;
        this._valueConverter = valueConverter;
        this._takeCompliment = takeCompliment;
    }

    @Override
    public double getFacetSelectivity(BoboSegmentReader reader) {
        double selectivity = 0.0;
        MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this._facetHandler.getFacetData(reader);
        int[] idxes = this._valueConverter.convert(dataCache, this._vals);
        if (idxes == null) {
            return 0.0;
        }
        int accumFreq = 0;
        for (int idx : idxes) {
            accumFreq += dataCache.freqs[idx];
        }
        int total = reader.maxDoc();
        selectivity = (double)accumFreq / (double)total;
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        long count;
        final MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this._facetHandler.getFacetData(reader);
        int[] index = this._valueConverter.convert(dataCache, this._vals);
        final BigNestedIntArray nestedArray = dataCache._nestedArray;
        final OpenBitSet bitset = new OpenBitSet((long)dataCache.valArray.size());
        for (int i : index) {
            bitset.fastSet(i);
        }
        if (this._takeCompliment) {
            int size = dataCache.valArray.size();
            for (int i = 0; i < size; ++i) {
                bitset.fastFlip(i);
            }
        }
        if ((count = bitset.cardinality()) == 0L) {
            final EmptyDocIdSet empty = EmptyDocIdSet.getInstance();
            return new RandomAccessDocIdSet(){

                @Override
                public boolean get(int docId) {
                    return false;
                }

                public DocIdSetIterator iterator() throws IOException {
                    return empty.iterator();
                }
            };
        }
        return new RandomAccessDocIdSet(){

            public DocIdSetIterator iterator() {
                return new MultiValueOrFacetDocIdSetIterator(dataCache, bitset);
            }

            @Override
            public final boolean get(int docId) {
                return nestedArray.contains(docId, bitset);
            }
        };
    }

    public static final class MultiValueOrFacetDocIdSetIterator
    extends FacetOrFilter.FacetOrDocIdSetIterator {
        private final BigNestedIntArray _nestedArray;

        public MultiValueOrFacetDocIdSetIterator(MultiValueFacetDataCache<?> dataCache, OpenBitSet bs) {
            super(dataCache, bs);
            this._nestedArray = dataCache._nestedArray;
        }

        @Override
        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._nestedArray.findValues(this._bitset, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        @Override
        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._nestedArray.findValues(this._bitset, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }
    }
}

