/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public class CompactMultiValueFacetFilter
extends RandomAccessFilter {
    private final FacetHandler<FacetDataCache<?>> _facetHandler;
    private final String[] _vals;

    public CompactMultiValueFacetFilter(FacetHandler<FacetDataCache<?>> facetHandler, String val) {
        this(facetHandler, new String[]{val});
    }

    public CompactMultiValueFacetFilter(FacetHandler<FacetDataCache<?>> facetHandler, String[] vals) {
        this._facetHandler = facetHandler;
        this._vals = vals;
    }

    @Override
    public double getFacetSelectivity(BoboSegmentReader reader) {
        double selectivity = 0.0;
        FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        int[] idxes = FacetDataCache.convert(dataCache, this._vals);
        if (idxes == null) {
            return 0.0;
        }
        int accumFreq = 0;
        for (int idx : idxes) {
            accumFreq += dataCache.freqs[idx];
        }
        int total = reader.maxDoc();
        selectivity = (double)accumFreq / (double)total;
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        final FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        final int[] indexes = FacetDataCache.convert(dataCache, this._vals);
        int bits = 0;
        for (int i : indexes) {
            bits |= 1 << i - 1;
        }
        final int finalBits = bits;
        final BigSegmentedArray orderArray = dataCache.orderArray;
        if (indexes.length == 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new RandomAccessDocIdSet(){

            public DocIdSetIterator iterator() {
                return new CompactMultiValueFacetDocIdSetIterator(dataCache, indexes, finalBits);
            }

            @Override
            public final boolean get(int docId) {
                return (orderArray.get(docId) & finalBits) != 0;
            }
        };
    }

    private static final class CompactMultiValueFacetDocIdSetIterator
    extends DocIdSetIterator {
        private final int _bits;
        private int _doc;
        private int _maxID;
        private final BigSegmentedArray _orderArray;

        public CompactMultiValueFacetDocIdSetIterator(FacetDataCache<?> dataCache, int[] index, int bits) {
            this._bits = bits;
            this._doc = Integer.MAX_VALUE;
            this._maxID = -1;
            this._orderArray = dataCache.orderArray;
            for (int i : index) {
                if (this._doc > dataCache.minIDs[i]) {
                    this._doc = dataCache.minIDs[i];
                }
                if (this._maxID >= dataCache.maxIDs[i]) continue;
                this._maxID = dataCache.maxIDs[i];
            }
            --this._doc;
            if (this._doc < 0) {
                this._doc = -1;
            }
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._orderArray.findBits(this._bits, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._orderArray.findBits(this._bits, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }

        public long cost() {
            return 0L;
        }
    }
}

