/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.range.MultiDataCacheBuilder;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigIntBuffer;
import com.browseengine.bobo.util.BigNestedIntArray;
import com.browseengine.bobo.util.StringArrayComparator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;

public class MultiValueFacetDataCache<T>
extends FacetDataCache<T> {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MultiValueFacetDataCache.class);
    public final BigNestedIntArray _nestedArray = new BigNestedIntArray();
    protected int _maxItems = 1024;
    protected boolean _overflow = false;

    public MultiValueFacetDataCache<T> setMaxItems(int maxItems) {
        this._maxItems = Math.min(maxItems, 1024);
        this._nestedArray.setMaxItems(this._maxItems);
        return this;
    }

    @Override
    public int getNumItems(int docid) {
        return this._nestedArray.getNumItems(docid);
    }

    @Override
    public void load(String fieldName, AtomicReader reader, TermListFactory<T> listFactory) throws IOException {
        this.load(fieldName, reader, listFactory, new BoboSegmentReader.WorkArea());
    }

    public void load(String fieldName, AtomicReader reader, TermListFactory<T> listFactory, BoboSegmentReader.WorkArea workArea) throws IOException {
        int doc;
        String field = fieldName.intern();
        int maxdoc = reader.maxDoc();
        BigNestedIntArray.BufferedLoader loader = this.getBufferedLoader(maxdoc, workArea);
        TermValueList list = listFactory == null ? new TermStringList() : listFactory.createTermList();
        IntArrayList minIDList = new IntArrayList();
        IntArrayList maxIDList = new IntArrayList();
        IntArrayList freqList = new IntArrayList();
        OpenBitSet bitset = new OpenBitSet((long)(maxdoc + 1));
        int negativeValueCount = this.getNegativeValueCount(reader, field);
        int t = 1;
        list.add(null);
        minIDList.add(-1);
        maxIDList.add(-1);
        freqList.add(0);
        this._overflow = false;
        Terms terms = reader.terms(field);
        if (terms != null) {
            BytesRef text;
            TermsEnum termsEnum = terms.iterator(null);
            while ((text = termsEnum.next()) != null) {
                int valId;
                String strText = text.utf8ToString();
                list.add(strText);
                Term term = new Term(field, strText);
                DocsEnum docsEnum = reader.termDocsEnum(term);
                int df = 0;
                int minID = -1;
                int maxID = -1;
                int docID = -1;
                int n = valId = t - 1 < negativeValueCount ? negativeValueCount - t + 1 : t;
                while ((docID = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    ++df;
                    if (!loader.add(docID, valId)) {
                        this.logOverflow(fieldName);
                    }
                    minID = docID;
                    bitset.fastSet(docID);
                    while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                        docID = docsEnum.docID();
                        ++df;
                        if (!loader.add(docID, valId)) {
                            this.logOverflow(fieldName);
                        }
                        bitset.fastSet(docID);
                    }
                    maxID = docID;
                }
                freqList.add(df);
                minIDList.add(minID);
                maxIDList.add(maxID);
                ++t;
            }
        }
        list.seal();
        try {
            this._nestedArray.load(maxdoc + 1, loader);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load due to " + e.toString(), e);
        }
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc < maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc < maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc - 1; doc >= 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            this.maxIDs[0] = doc;
        }
        this.freqs[0] = maxdoc - (int)bitset.cardinality();
    }

    public void load(String fieldName, AtomicReader reader, TermListFactory<T> listFactory, Term sizeTerm) throws IOException {
        int doc;
        String field = fieldName.intern();
        int maxdoc = reader.maxDoc();
        AllocOnlyLoader loader = new AllocOnlyLoader(this._maxItems, sizeTerm, reader);
        int negativeValueCount = this.getNegativeValueCount(reader, field);
        try {
            this._nestedArray.load(maxdoc + 1, loader);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load due to " + e.toString(), e);
        }
        TermValueList list = listFactory == null ? new TermStringList() : listFactory.createTermList();
        IntArrayList minIDList = new IntArrayList();
        IntArrayList maxIDList = new IntArrayList();
        IntArrayList freqList = new IntArrayList();
        OpenBitSet bitset = new OpenBitSet((long)(maxdoc + 1));
        int t = 1;
        list.add(null);
        minIDList.add(-1);
        maxIDList.add(-1);
        freqList.add(0);
        this._overflow = false;
        Terms terms = reader.terms(field);
        if (terms != null) {
            BytesRef text;
            TermsEnum termsEnum = terms.iterator(null);
            while ((text = termsEnum.next()) != null) {
                String strText = text.utf8ToString();
                list.add(strText);
                Term term = new Term(field, strText);
                DocsEnum docsEnum = reader.termDocsEnum(term);
                int df = 0;
                int minID = -1;
                int maxID = -1;
                int docID = -1;
                while ((docID = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    int valId;
                    ++df;
                    if (!this._nestedArray.addData(docID, t)) {
                        this.logOverflow(fieldName);
                    }
                    minID = docID;
                    bitset.fastSet(docID);
                    int n = valId = t - 1 < negativeValueCount ? negativeValueCount - t + 1 : t;
                    while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                        docID = docsEnum.docID();
                        ++df;
                        if (!this._nestedArray.addData(docID, valId)) {
                            this.logOverflow(fieldName);
                        }
                        bitset.fastSet(docID);
                    }
                    maxID = docID;
                }
                freqList.add(df);
                minIDList.add(minID);
                maxIDList.add(maxID);
                ++t;
            }
        }
        list.seal();
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc < maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc < maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc - 1; doc >= 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            this.maxIDs[0] = doc;
        }
        this.freqs[0] = maxdoc - (int)bitset.cardinality();
    }

    protected void logOverflow(String fieldName) {
        if (!this._overflow) {
            logger.error((Object)("Maximum value per document: " + this._maxItems + " exceeded, fieldName=" + fieldName));
            this._overflow = true;
        }
    }

    protected BigNestedIntArray.BufferedLoader getBufferedLoader(int maxdoc, BoboSegmentReader.WorkArea workArea) {
        if (workArea == null) {
            return new BigNestedIntArray.BufferedLoader(maxdoc, this._maxItems, new BigIntBuffer());
        }
        BigIntBuffer buffer = workArea.get(BigIntBuffer.class);
        if (buffer == null) {
            buffer = new BigIntBuffer();
            workArea.put(buffer);
        } else {
            buffer.reset();
        }
        BigNestedIntArray.BufferedLoader loader = workArea.get(BigNestedIntArray.BufferedLoader.class);
        if (loader == null || loader.capacity() < maxdoc) {
            loader = new BigNestedIntArray.BufferedLoader(maxdoc, this._maxItems, buffer);
            workArea.put(loader);
        } else {
            loader.reset(maxdoc, this._maxItems, buffer);
        }
        return loader;
    }

    public static final class MultiFacetDocComparatorSource
    extends DocComparatorSource {
        private final MultiDataCacheBuilder cacheBuilder;

        public MultiFacetDocComparatorSource(MultiDataCacheBuilder multiDataCacheBuilder) {
            this.cacheBuilder = multiDataCacheBuilder;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            if (!(reader instanceof BoboSegmentReader)) {
                throw new IllegalStateException("reader must be instance of " + BoboSegmentReader.class);
            }
            BoboSegmentReader boboReader = (BoboSegmentReader)reader;
            FacetDataCache dataCache = this.cacheBuilder.build(boboReader);
            return new DocComparator((MultiValueFacetDataCache)dataCache){
                final /* synthetic */ MultiValueFacetDataCache val$dataCache;
                {
                    this.val$dataCache = multiValueFacetDataCache;
                }

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return this.val$dataCache._nestedArray.compare(doc1.doc, doc2.doc);
                }

                @Override
                public Comparable<?> value(ScoreDoc doc) {
                    String[] vals = this.val$dataCache._nestedArray.getTranslatedData(doc.doc, this.val$dataCache.valArray);
                    return new StringArrayComparator(vals);
                }
            };
        }
    }

    public static final class AllocOnlyLoader
    extends BigNestedIntArray.Loader {
        private final AtomicReader _reader;
        private final Term _sizeTerm;
        private final int _maxItems;

        public AllocOnlyLoader(int maxItems, Term sizeTerm, AtomicReader reader) throws IOException {
            this._maxItems = Math.min(maxItems, 1024);
            this._sizeTerm = sizeTerm;
            this._reader = reader;
        }

        @Override
        public void load() throws Exception {
            DocsAndPositionsEnum docPosEnum = this._reader.termPositionsEnum(this._sizeTerm);
            if (docPosEnum == null) {
                return;
            }
            int docID = -1;
            while ((docID = docPosEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (docPosEnum.freq() <= 0) continue;
                docPosEnum.nextPosition();
                int len = AllocOnlyLoader.bytesToInt(docPosEnum.getPayload().bytes);
                this.allocate(docID, Math.min(len, this._maxItems), true);
            }
        }

        private static int bytesToInt(byte[] bytes) {
            return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }
    }
}

