/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.ImmutableDocSet;
import com.browseengine.bobo.docidset.OrDocIdSetIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class OrDocIdSet
extends ImmutableDocSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INVALID = -1;
    List<DocIdSet> sets = null;
    private int _size = -1;

    public OrDocIdSet(List<DocIdSet> docSets) {
        this.sets = docSets;
        if (this.sets != null) {
            for (DocIdSet set : this.sets) {
                if (set == null) continue;
            }
        }
    }

    public DocIdSetIterator iterator() throws IOException {
        return new OrDocIdSetIterator(this.sets);
    }

    @Override
    public int findWithIndex(int val) throws IOException {
        OrDocIdSetIterator finder = new OrDocIdSetIterator(this.sets);
        int cursor = -1;
        try {
            int docid;
            while ((docid = finder.nextDoc()) != Integer.MAX_VALUE) {
                if (docid > val) {
                    return -1;
                }
                if (docid == val) {
                    return ++cursor;
                }
                ++cursor;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return -1;
    }

    @Override
    public int size() throws IOException {
        if (this._size == -1) {
            this._size = 0;
            DocIdSetIterator it = this.iterator();
            try {
                while (it.nextDoc() != Integer.MAX_VALUE) {
                    ++this._size;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this._size = -1;
            }
        }
        return this._size;
    }

    public class AescDocIdSetComparator
    implements Comparator<DocIdSetIterator>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(DocIdSetIterator o1, DocIdSetIterator o2) {
            return o1.docID() - o2.docID();
        }
    }
}

