/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.Conversion;
import com.browseengine.bobo.docidset.PrimitiveArray;
import java.io.IOException;
import java.io.Serializable;

public class IntArray
extends PrimitiveArray<Integer>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public IntArray(int len) {
        super(len);
    }

    public IntArray() {
    }

    public void add(int val) {
        this.ensureCapacity(this._count + 1);
        int[] array = (int[])this._array;
        array[this._count] = val;
        ++this._count;
    }

    public void set(int index, int val) {
        this.ensureCapacity(index);
        int[] array = (int[])this._array;
        array[index] = val;
        this._count = Math.max(this._count, index + 1);
    }

    public int get(int index) {
        int[] array = (int[])this._array;
        return array[index];
    }

    public boolean contains(int elem) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) != elem) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object buildArray(int len) {
        return new int[len];
    }

    public static int getSerialIntNum(IntArray instance) {
        int num = 3 + instance._count;
        return num;
    }

    public static int convertToBytes(IntArray instance, byte[] out, int offset) {
        int numInt = 0;
        Conversion.intToByteArray(instance._len, out, offset);
        ++numInt;
        Conversion.intToByteArray(instance._count, out, offset += 4);
        ++numInt;
        Conversion.intToByteArray(instance._growth, out, offset += 4);
        offset += 4;
        ++numInt;
        for (int i = 0; i < instance.size(); ++i) {
            int data = instance.get(i);
            Conversion.intToByteArray(data, out, offset);
            offset += 4;
        }
        return numInt += instance.size();
    }

    public static IntArray newInstanceFromBytes(byte[] inData, int offset) throws IOException {
        int len = Conversion.byteArrayToInt(inData, offset);
        IntArray instance = new IntArray(len);
        int count = Conversion.byteArrayToInt(inData, offset += 4);
        int growth = Conversion.byteArrayToInt(inData, offset += 4);
        offset += 4;
        for (int i = 0; i < count; ++i) {
            int data = Conversion.byteArrayToInt(inData, offset);
            offset += 4;
            instance.add(data);
        }
        instance._growth = growth;
        if (instance._count != count) {
            throw new IOException("cannot build IntArray from byte[]");
        }
        return instance;
    }
}

