/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.DocSet;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class ImmutableDocSet
extends DocSet {
    private int size = -1;
    private final Logger log = Logger.getLogger(ImmutableDocSet.class.getName());

    @Override
    public void addDoc(int docid) {
        throw new UnsupportedOperationException("Attempt to add document to an immutable data structure");
    }

    @Override
    public int size() throws IOException {
        if (this.size < 0) {
            DocIdSetIterator dcit = this.iterator();
            this.size = 0;
            try {
                while (dcit.nextDoc() != Integer.MAX_VALUE) {
                    ++this.size;
                }
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Error computing size..");
                return -1;
            }
        }
        return this.size;
    }
}

