/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.api.BoboCustomSortField;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.sort.MultiDocIdComparatorSource;
import com.browseengine.bobo.sort.ReverseDocComparatorSource;
import com.browseengine.bobo.sort.SortCollectorImpl;
import com.browseengine.bobo.util.MemoryManager;
import com.browseengine.bobo.util.MemoryManagerAdminMBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public abstract class SortCollector
extends Collector {
    private static final Logger logger = Logger.getLogger(SortCollector.class);
    protected static MemoryManager<int[]> intarraymgr = new MemoryManager<int[]>(new MemoryManager.Initializer<int[]>(){

        @Override
        public void init(int[] buf) {
            Arrays.fill(buf, 0);
        }

        @Override
        public int[] newInstance(int size) {
            return new int[size];
        }

        @Override
        public int size(int[] buf) {
            assert (buf != null);
            return buf.length;
        }
    });
    protected static MemoryManager<float[]> floatarraymgr = new MemoryManager<float[]>(new MemoryManager.Initializer<float[]>(){

        @Override
        public void init(float[] buf) {
            Arrays.fill(buf, 0.0f);
        }

        @Override
        public float[] newInstance(int size) {
            return new float[size];
        }

        @Override
        public int size(float[] buf) {
            assert (buf != null);
            return buf.length;
        }
    });
    public FacetHandler<?> groupBy = null;
    public FacetHandler<?>[] groupByMulti = null;
    public LinkedList<CollectorContext> contextList;
    public LinkedList<int[]> docidarraylist;
    public LinkedList<float[]> scorearraylist;
    public static int BLOCK_SIZE;
    protected Collector _collector = null;
    protected final SortField[] _sortFields;
    protected final boolean _fetchStoredFields;
    protected boolean _closed = false;

    protected SortCollector(SortField[] sortFields, boolean fetchStoredFields) {
        this._sortFields = sortFields;
        this._fetchStoredFields = fetchStoredFields;
    }

    public abstract BrowseHit[] topDocs() throws IOException;

    public abstract int getTotalHits();

    public abstract int getTotalGroups();

    public abstract FacetAccessible[] getGroupAccessibles();

    private static DocComparatorSource getNonFacetComparatorSource(SortField sf) {
        String fieldname = sf.getField();
        Locale locale = sf.getLocale();
        if (locale != null) {
            return new DocComparatorSource.StringLocaleComparatorSource(fieldname, locale);
        }
        int type = sf.getType();
        switch (type) {
            case 4: {
                return new DocComparatorSource.IntDocComparatorSource(fieldname);
            }
            case 5: {
                return new DocComparatorSource.FloatDocComparatorSource(fieldname);
            }
            case 6: {
                return new DocComparatorSource.LongDocComparatorSource(fieldname);
            }
            case 7: {
                return new DocComparatorSource.LongDocComparatorSource(fieldname);
            }
            case 10: {
                return new DocComparatorSource.ByteDocComparatorSource(fieldname);
            }
            case 8: {
                return new DocComparatorSource.ShortDocComparatorSource(fieldname);
            }
            case 9: {
                throw new IllegalArgumentException("lucene custom sort no longer supported: " + fieldname);
            }
            case 3: {
                return new DocComparatorSource.StringOrdComparatorSource(fieldname);
            }
            case 11: {
                return new DocComparatorSource.StringValComparatorSource(fieldname);
            }
        }
        throw new IllegalStateException("Illegal sort type: " + type + ", for field: " + fieldname);
    }

    private static DocComparatorSource getComparatorSource(Browsable browser, SortField sf) {
        DocComparatorSource compSource = null;
        if (SortField.FIELD_DOC.equals((Object)sf)) {
            compSource = new DocComparatorSource.DocIdDocComparatorSource();
        } else if (SortField.FIELD_SCORE.equals((Object)sf) || sf.getType() == 0) {
            compSource = new ReverseDocComparatorSource(new DocComparatorSource.RelevanceDocComparatorSource());
        } else if (sf instanceof BoboCustomSortField) {
            BoboCustomSortField custField = (BoboCustomSortField)sf;
            DocComparatorSource src = custField.getCustomComparatorSource();
            assert (src != null);
            compSource = src;
        } else {
            String sortName;
            Set<String> facetNames = browser.getFacetNames();
            if (facetNames.contains(sortName = sf.getField())) {
                FacetHandler<?> handler = browser.getFacetHandler(sortName);
                assert (handler != null);
                compSource = handler.getDocComparatorSource();
            } else {
                logger.info((Object)("doing default lucene sort for: " + sf));
                compSource = SortCollector.getNonFacetComparatorSource(sf);
            }
        }
        boolean reverse = sf.getReverse();
        if (reverse) {
            compSource = new ReverseDocComparatorSource(compSource);
        }
        compSource.setReverse(reverse);
        return compSource;
    }

    private static SortField convert(Browsable browser, SortField sort) {
        String field = sort.getField();
        FacetHandler<?> facetHandler = browser.getFacetHandler(field);
        if (facetHandler != null) {
            browser.getFacetHandler(field);
            BoboCustomSortField sortField = new BoboCustomSortField(field, sort.getReverse(), facetHandler.getDocComparatorSource());
            return sortField;
        }
        return sort;
    }

    public static SortCollector buildSortCollector(Browsable browser, Query q, SortField[] sort, int offset, int count, boolean forceScoring, boolean fetchStoredFields, Set<String> termVectorsToFetch, String[] groupBy, int maxPerGroup, boolean collectDocIdCache) {
        DocComparatorSource compSource;
        boolean doScoring = forceScoring;
        if (!(sort != null && sort.length != 0 || q == null || q instanceof MatchAllDocsQuery)) {
            sort = new SortField[]{SortField.FIELD_SCORE};
        }
        if (sort == null || sort.length == 0) {
            sort = new SortField[]{SortField.FIELD_DOC};
        }
        Set<String> facetNames = browser.getFacetNames();
        for (SortField sf : sort) {
            if (sf.getType() != 0) continue;
            doScoring = true;
            break;
        }
        if (sort.length == 1) {
            SortField sf = SortCollector.convert(browser, sort[0]);
            compSource = SortCollector.getComparatorSource(browser, sf);
        } else {
            DocComparatorSource[] compSources = new DocComparatorSource[sort.length];
            for (int i = 0; i < sort.length; ++i) {
                compSources[i] = SortCollector.getComparatorSource(browser, SortCollector.convert(browser, sort[i]));
            }
            compSource = new MultiDocIdComparatorSource(compSources);
        }
        return new SortCollectorImpl(compSource, sort, browser, offset, count, doScoring, fetchStoredFields, termVectorsToFetch, groupBy, maxPerGroup, collectDocIdCache);
    }

    public SortCollector setCollector(Collector collector) {
        this._collector = collector;
        return this;
    }

    public Collector getCollector() {
        return this._collector;
    }

    public void close() {
        if (!this._closed) {
            this._closed = true;
            if (this.docidarraylist != null) {
                while (!this.docidarraylist.isEmpty()) {
                    intarraymgr.release(this.docidarraylist.poll());
                }
            }
            if (this.scorearraylist != null) {
                while (!this.scorearraylist.isEmpty()) {
                    floatarraymgr.release(this.scorearraylist.poll());
                }
            }
        }
    }

    static {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbeanName = new ObjectName("bobo", "name", "SortCollectorImpl-MemoryManager-Int");
            StandardMBean mbean = new StandardMBean(intarraymgr.getAdminMBean(), MemoryManagerAdminMBean.class);
            mbeanServer.registerMBean(mbean, mbeanName);
            mbeanName = new ObjectName("bobo", "name", "SortCollectorImpl-MemoryManager-Float");
            mbean = new StandardMBean(floatarraymgr.getAdminMBean(), MemoryManagerAdminMBean.class);
            mbeanServer.registerMBean(mbean, mbeanName);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BLOCK_SIZE = 4096;
    }

    public static class CollectorContext {
        public BoboIndexReader reader;
        public int base;
        public DocComparator comparator;
        public int length;

        public CollectorContext(BoboIndexReader reader, int base, DocComparator comparator) {
            this.reader = reader;
            this.base = base;
            this.comparator = comparator;
        }
    }
}

