/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query;

import com.browseengine.bobo.query.ScorerBuilder;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class ScoreAdjusterQuery
extends Query {
    private static final long serialVersionUID = 1L;
    protected final Query _query;
    protected final ScorerBuilder _scorerBuilder;

    public ScoreAdjusterQuery(Query query, ScorerBuilder scorerBuilder) {
        this._query = query;
        this._scorerBuilder = scorerBuilder;
    }

    public void extractTerms(Set terms) {
        this._query.extractTerms(terms);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new ScoreAdjusterWeight(this._query.createWeight(searcher));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        this._query.rewrite(reader);
        return this;
    }

    public String toString(String field) {
        return this._query.toString(field);
    }

    private class ScoreAdjusterWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        Weight _innerWeight;

        public ScoreAdjusterWeight(Weight innerWeight) throws IOException {
            this._innerWeight = innerWeight;
        }

        public String toString() {
            return "weight(" + (Object)((Object)ScoreAdjusterQuery.this) + ")";
        }

        public Query getQuery() {
            return this._innerWeight.getQuery();
        }

        public float getValue() {
            return this._innerWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            return this._innerWeight.sumOfSquaredWeights();
        }

        public void normalize(float queryNorm) {
            this._innerWeight.normalize(queryNorm);
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer innerScorer = this._innerWeight.scorer(reader, scoreDocsInOrder, topScorer);
            return ScoreAdjusterQuery.this._scorerBuilder.createScorer(innerScorer, reader, scoreDocsInOrder, topScorer);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation innerExplain = this._innerWeight.explain(reader, doc);
            return ScoreAdjusterQuery.this._scorerBuilder.explain(reader, doc, innerExplain);
        }
    }
}

