/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.filter.AdaptiveFacetFilter;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.MultiValueORFacetFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.range.BitSetBuilder;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

public class BitSetFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    protected final AdaptiveFacetFilter.FacetDataCacheBuilder facetDataCacheBuilder;
    protected final BitSetBuilder bitSetBuilder;
    private volatile OpenBitSet bitSet;
    private volatile FacetDataCache lastCache;

    public BitSetFilter(BitSetBuilder bitSetBuilder, AdaptiveFacetFilter.FacetDataCacheBuilder facetDataCacheBuilder) {
        this.bitSetBuilder = bitSetBuilder;
        this.facetDataCacheBuilder = facetDataCacheBuilder;
    }

    public OpenBitSet getBitSet(FacetDataCache dataCache) {
        if (this.lastCache == dataCache) {
            return this.bitSet;
        }
        this.bitSet = this.bitSetBuilder.bitSet(dataCache);
        this.lastCache = dataCache;
        return this.bitSet;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        final FacetDataCache dataCache = this.facetDataCacheBuilder.build(reader);
        final OpenBitSet openBitSet = this.getBitSet(dataCache);
        long count = openBitSet.cardinality();
        if (count == 0L) {
            return EmptyDocIdSet.getInstance();
        }
        final boolean multi = dataCache instanceof MultiValueFacetDataCache;
        final MultiValueFacetDataCache multiCache = multi ? (MultiValueFacetDataCache)dataCache : null;
        return new RandomAccessDocIdSet(){

            public DocIdSetIterator iterator() {
                if (multi) {
                    return new MultiValueORFacetFilter.MultiValueOrFacetDocIdSetIterator(multiCache, openBitSet);
                }
                return new FacetOrFilter.FacetOrDocIdSetIterator(dataCache, openBitSet);
            }

            @Override
            public boolean get(int docId) {
                if (multi) {
                    return multiCache._nestedArray.contains(docId, openBitSet);
                }
                return openBitSet.fastGet(dataCache.orderArray.get(docId));
            }
        };
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        FacetDataCache dataCache = this.facetDataCacheBuilder.build(reader);
        OpenBitSet openBitSet = this.getBitSet(dataCache);
        int[] frequencies = dataCache.freqs;
        double selectivity = 0.0;
        int accumFreq = 0;
        int index = openBitSet.nextSetBit(0);
        while (index >= 0) {
            accumFreq += frequencies[index];
            index = openBitSet.nextSetBit(index + 1);
        }
        int total = reader.maxDoc();
        selectivity = (double)accumFreq / (double)total;
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }
}

