/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.kamikaze.docidset.impl.OrDocIdSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class RandomAccessOrFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    protected final List<RandomAccessFilter> _filters;

    public RandomAccessOrFilter(List<RandomAccessFilter> filters) {
        if (filters == null) {
            Exception e = new Exception();
            e.fillInStackTrace();
            e.printStackTrace();
        }
        this._filters = filters;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = 0.0;
        for (RandomAccessFilter filter : this._filters) {
            selectivity += filter.getFacetSelectivity(reader);
        }
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        if (this._filters.size() == 1) {
            return this._filters.get(0).getRandomAccessDocIdSet(reader);
        }
        ArrayList<RandomAccessDocIdSet> list = new ArrayList<RandomAccessDocIdSet>(this._filters.size());
        ArrayList<RandomAccessDocIdSet> randomAccessList = new ArrayList<RandomAccessDocIdSet>(this._filters.size());
        for (RandomAccessFilter f : this._filters) {
            RandomAccessDocIdSet s = f.getRandomAccessDocIdSet(reader);
            list.add(s);
            randomAccessList.add(s);
        }
        final RandomAccessDocIdSet[] randomAccessDocIdSets = randomAccessList.toArray(new RandomAccessDocIdSet[randomAccessList.size()]);
        OrDocIdSet orDocIdSet = new OrDocIdSet(list);
        return new RandomAccessDocIdSet((DocIdSet)orDocIdSet){
            final /* synthetic */ DocIdSet val$orDocIdSet;
            {
                this.val$orDocIdSet = docIdSet;
            }

            @Override
            public boolean get(int docId) {
                for (RandomAccessDocIdSet s : randomAccessDocIdSets) {
                    if (!s.get(docId)) continue;
                    return true;
                }
                return false;
            }

            public DocIdSetIterator iterator() throws IOException {
                return this.val$orDocIdSet.iterator();
            }
        };
    }
}

