/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class BrowseSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ValueOperation selectionOperation;
    private String fieldName;
    protected ArrayList<String> values;
    protected ArrayList<String> notValues;
    private Properties _selectionProperties;

    public void setSelectionProperty(String key, String val) {
        this._selectionProperties.setProperty(key, val);
    }

    public void setSelectionProperties(Map<String, String> props) {
        this._selectionProperties.putAll(props);
    }

    public boolean isStrict() {
        return Boolean.valueOf(this._selectionProperties.getProperty("strict"));
    }

    public BrowseSelection setStrict(boolean strict) {
        this._selectionProperties.setProperty("strict", String.valueOf(strict));
        return this;
    }

    public int getDepth() {
        try {
            return Integer.parseInt(this._selectionProperties.getProperty("depth"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public BrowseSelection setDepth(int depth) {
        this._selectionProperties.setProperty("depth", String.valueOf(depth));
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String[] getValues() {
        return this.values.toArray(new String[this.values.size()]);
    }

    public String[] getNotValues() {
        return this.notValues.toArray(new String[this.notValues.size()]);
    }

    public BrowseSelection setValues(String[] vals) {
        this.values.clear();
        for (int i = 0; i < vals.length; ++i) {
            this.values.add(vals[i]);
        }
        return this;
    }

    public BrowseSelection addValue(String val) {
        this.values.add(val);
        return this;
    }

    public BrowseSelection addNotValue(String val) {
        this.notValues.add(val);
        return this;
    }

    public BrowseSelection setNotValues(String[] notVals) {
        this.notValues.clear();
        for (int i = 0; i < notVals.length; ++i) {
            this.notValues.add(notVals[i]);
        }
        return this;
    }

    public BrowseSelection(String fieldName) {
        this.fieldName = fieldName;
        this.values = new ArrayList();
        this.notValues = new ArrayList();
        this.selectionOperation = ValueOperation.ValueOperationOr;
        this._selectionProperties = new Properties();
    }

    public Properties getSelectionProperties() {
        return this._selectionProperties;
    }

    public ValueOperation getSelectionOperation() {
        return this.selectionOperation;
    }

    public BrowseSelection setSelectionOperation(ValueOperation selectionOperation) {
        this.selectionOperation = selectionOperation;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name: ").append(this.fieldName);
        buf.append("values: " + this.values);
        buf.append("nots: " + this.notValues);
        buf.append("op: " + (Object)((Object)this.selectionOperation));
        buf.append("sel props: " + this._selectionProperties);
        return buf.toString();
    }

    public static enum ValueOperation {
        ValueOperationOr,
        ValueOperationAnd;

    }
}

