/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.sort.SortCollector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BrowseResult
implements Serializable {
    private static final long serialVersionUID = -8620935391852879446L;
    private long tid = -1L;
    private int numHits = 0;
    private int numGroups = 0;
    private int totalDocs = 0;
    private FacetAccessible _groupAccessible = null;
    private transient SortCollector _sortCollector = null;
    private Map<String, FacetAccessible> _facetMap = new HashMap<String, FacetAccessible>();
    private BrowseHit[] hits = null;
    private long time = 0L;
    private static BrowseHit[] NO_HITS = new BrowseHit[0];

    public final long getTid() {
        return this.tid;
    }

    public final void setTid(long tid) {
        this.tid = tid;
    }

    public FacetAccessible getGroupAccessible() {
        return this._groupAccessible;
    }

    public BrowseResult setGroupAccessible(FacetAccessible groupAccessible) {
        this._groupAccessible = groupAccessible;
        return this;
    }

    public SortCollector getSortCollector() {
        return this._sortCollector;
    }

    public BrowseResult setSortCollector(SortCollector sortCollector) {
        this._sortCollector = sortCollector;
        return this;
    }

    public FacetAccessible getFacetAccessor(String name) {
        return this._facetMap.get(name);
    }

    public int getNumHits() {
        return this.numHits;
    }

    public BrowseResult setNumHits(int hits) {
        this.numHits = hits;
        return this;
    }

    public int getNumGroups() {
        return this.numGroups;
    }

    public BrowseResult setNumGroups(int groups) {
        this.numGroups = groups;
        return this;
    }

    public int getTotalDocs() {
        return this.totalDocs;
    }

    public BrowseResult setTotalDocs(int docs) {
        this.totalDocs = docs;
        return this;
    }

    public BrowseResult addFacets(String name, FacetAccessible facets) {
        this._facetMap.put(name, facets);
        return this;
    }

    public BrowseResult addAll(Map<String, FacetAccessible> facets) {
        this._facetMap.putAll(facets);
        return this;
    }

    public BrowseResult setHits(BrowseHit[] hits) {
        this.hits = hits;
        return this;
    }

    public BrowseHit[] getHits() {
        return this.hits == null ? NO_HITS : this.hits;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public Map<String, FacetAccessible> getFacetMap() {
        return this._facetMap;
    }

    public static String toString(Map<String, FacetAccessible> map) {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<String, FacetAccessible>> entries = map.entrySet();
        buffer.append("{");
        for (Map.Entry<String, FacetAccessible> entry : entries) {
            String name = entry.getKey();
            FacetAccessible facetAccessor = entry.getValue();
            buffer.append("name=").append(name).append(",");
            buffer.append("facets=").append(facetAccessor.getFacets()).append(";");
        }
        buffer.append("}").append('\n');
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("hit count: ").append(this.numHits).append('\n');
        buf.append("total docs: ").append(this.totalDocs).append('\n');
        buf.append("facets: ").append(BrowseResult.toString(this._facetMap));
        buf.append("hits: ").append(Arrays.toString(this.hits));
        return buf.toString();
    }

    public void close() {
        if (this._groupAccessible != null) {
            this._groupAccessible.close();
        }
        if (this._sortCollector != null) {
            this._sortCollector.close();
        }
        if (this._facetMap == null) {
            return;
        }
        Collection<FacetAccessible> accessibles = this._facetMap.values();
        for (FacetAccessible fa : accessibles) {
            fa.close();
        }
    }
}

