/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.sort.DocComparator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;

public class MultiDocIdComparator
extends DocComparator {
    private final DocComparator[] _comparators;

    public MultiDocIdComparator(DocComparator[] comparators) {
        this._comparators = comparators;
    }

    @Override
    public int compare(ScoreDoc doc1, ScoreDoc doc2) {
        for (int i = 0; i < this._comparators.length; ++i) {
            int v = this._comparators[i].compare(doc1, doc2);
            if (v == 0) continue;
            return v;
        }
        return 0;
    }

    @Override
    public void setScorer(Scorer scorer) {
        for (DocComparator comparator : this._comparators) {
            comparator.setScorer(scorer);
        }
    }

    @Override
    public Comparable value(ScoreDoc doc) {
        return new MultiDocIdComparable(doc, this._comparators);
    }

    public static class MultiDocIdComparable
    implements Comparable {
        private ScoreDoc _doc;
        private DocComparator[] _comparators;

        public MultiDocIdComparable(ScoreDoc doc, DocComparator[] comparators) {
            this._doc = doc;
            this._comparators = comparators;
        }

        public int compareTo(Object o) {
            MultiDocIdComparable other = (MultiDocIdComparable)o;
            for (int i = 0; i < this._comparators.length; ++i) {
                Comparable c2;
                Comparable c1 = this._comparators[i].value(this._doc);
                int v = c1.compareTo(c2 = other._comparators[i].value(other._doc));
                if (v == 0) continue;
                return v;
            }
            return 0;
        }
    }
}

