/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query.scoring;

import com.browseengine.bobo.query.scoring.FacetTermScoringFunction;
import java.util.Arrays;
import org.apache.lucene.search.Explanation;

public class MultiplicativeFacetTermScoringFunction
implements FacetTermScoringFunction {
    private float _boost = 1.0f;

    @Override
    public final void clearScores() {
        this._boost = 1.0f;
    }

    @Override
    public final float score(int df, float boost) {
        return boost;
    }

    @Override
    public final void scoreAndCollect(int df, float boost) {
        this._boost *= boost;
    }

    @Override
    public final float getCurrentScore() {
        return this._boost;
    }

    @Override
    public Explanation explain(int df, float boost) {
        Explanation expl = new Explanation();
        expl.setValue(this.score(df, boost));
        expl.setDescription("boost value of: " + boost);
        return expl;
    }

    @Override
    public Explanation explain(float ... scores) {
        Explanation expl = new Explanation();
        float boost = 1.0f;
        for (float score : scores) {
            boost *= score;
        }
        expl.setValue(boost);
        expl.setDescription("product of: " + Arrays.toString(scores));
        return expl;
    }
}

