/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RangeFacetCountCollector
implements FacetCountCollector {
    private final FacetSpec _ospec;
    private int[] _count;
    private int _countlength;
    private final BigSegmentedArray _array;
    private FacetDataCache _dataCache;
    private final String _name;
    private final TermStringList _predefinedRanges;
    private int[][] _predefinedRangeIndexes;
    private int _docBase;

    protected RangeFacetCountCollector(String name, FacetDataCache dataCache, int docBase, FacetSpec ospec, List<String> predefinedRanges) {
        this._name = name;
        this._dataCache = dataCache;
        this._countlength = this._dataCache.freqs.length;
        this._count = new int[this._countlength];
        this._array = this._dataCache.orderArray;
        this._docBase = docBase;
        this._ospec = ospec;
        if (predefinedRanges != null) {
            this._predefinedRanges = new TermStringList();
            Collections.sort(predefinedRanges);
            this._predefinedRanges.addAll((Collection<? extends String>)predefinedRanges);
        } else {
            this._predefinedRanges = null;
        }
        if (this._predefinedRanges != null) {
            this._predefinedRangeIndexes = new int[this._predefinedRanges.size()][];
            int i = 0;
            for (String range : this._predefinedRanges) {
                this._predefinedRangeIndexes[i++] = FacetRangeFilter.parse(this._dataCache, range);
            }
        }
    }

    @Override
    public int[] getCountDistribution() {
        int[] dist;
        if (this._predefinedRangeIndexes != null) {
            dist = new int[this._predefinedRangeIndexes.length];
            int n = 0;
            for (int[] range : this._predefinedRangeIndexes) {
                int start = range[0];
                int end = range[1];
                int sum = 0;
                for (int i = start; i < end; ++i) {
                    sum += this._count[i];
                }
                dist[n++] = sum;
            }
        } else {
            dist = this._count;
        }
        return dist;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public BrowseFacet getFacet(String value) {
        BrowseFacet facet = null;
        int[] range = FacetRangeFilter.parse(this._dataCache, value);
        if (range != null) {
            int sum = 0;
            for (int i = range[0]; i <= range[1]; ++i) {
                sum += this._count[i];
            }
            facet = new BrowseFacet(value, sum);
        }
        return facet;
    }

    @Override
    public final void collect(int docid) {
        int n = this._array.get(docid);
        this._count[n] = this._count[n] + 1;
    }

    @Override
    public final void collectAll() {
        this._count = this._dataCache.freqs;
        this._countlength = this._dataCache.freqs.length;
    }

    void convertFacets(BrowseFacet[] facets) {
        int i = 0;
        for (BrowseFacet facet : facets) {
            int hit = facet.getHitCount();
            String val = facet.getValue();
            RangeFacet rangeFacet = new RangeFacet();
            rangeFacet.setValues(val, val);
            rangeFacet.setHitCount(hit);
            facets[i++] = rangeFacet;
        }
    }

    private BrowseFacet[] foldChoices(BrowseFacet[] choices, int max) {
        if (max == 0 || choices.length <= max) {
            return choices;
        }
        ArrayList<RangeFacet> list = new ArrayList<RangeFacet>();
        for (int i = 0; i < choices.length; i += 2) {
            RangeFacet[] rChoices;
            RangeFacet rangeChoice = new RangeFacet();
            if (i + 1 < choices.length) {
                if (choices instanceof RangeFacet[]) {
                    rChoices = (RangeFacet[])choices;
                    String val1 = rChoices[i]._lower;
                    String val2 = rChoices[i + 1]._upper;
                    rangeChoice.setValues(val1, val2);
                    rangeChoice.setHitCount(choices[i].getHitCount() + choices[i + 1].getHitCount());
                } else {
                    rangeChoice.setValues(choices[i].getValue(), choices[i + 1].getValue());
                    rangeChoice.setHitCount(choices[i].getHitCount() + choices[i + 1].getHitCount());
                }
            } else {
                if (choices instanceof RangeFacet[]) {
                    rChoices = (RangeFacet[])choices;
                    rangeChoice.setValues(rChoices[i]._lower, rChoices[i]._upper);
                } else {
                    rangeChoice.setValues(choices[i].getValue(), choices[i].getValue());
                }
                rangeChoice.setHitCount(choices[i].getHitCount());
            }
            list.add(rangeChoice);
        }
        BrowseFacet[] result = new RangeFacet[list.size()];
        result = list.toArray(result);
        return this.foldChoices(result, max);
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._ospec != null) {
            if (this._predefinedRangeIndexes != null) {
                int minCount = this._ospec.getMinHitCount();
                ArrayList<BrowseFacet> list = new ArrayList<BrowseFacet>(this._predefinedRangeIndexes.length);
                for (int k = 0; k < this._predefinedRangeIndexes.length; ++k) {
                    int count = 0;
                    int idx = this._predefinedRangeIndexes[k][0];
                    int end = this._predefinedRangeIndexes[k][1];
                    while (idx <= end) {
                        count += this._count[idx++];
                    }
                    if (count < minCount) continue;
                    BrowseFacet choice = new BrowseFacet();
                    choice.setHitCount(count);
                    choice.setValue(this._predefinedRanges.get(k));
                    list.add(choice);
                }
                return list;
            }
            return FacetCountCollector.EMPTY_FACET_LIST;
        }
        return FacetCountCollector.EMPTY_FACET_LIST;
    }

    @Override
    public void close() {
    }

    @Override
    public FacetIterator iterator() {
        if (this._predefinedRanges != null) {
            int[] rangeCounts = new int[this._predefinedRangeIndexes.length];
            int k = 0;
            while (k < this._predefinedRangeIndexes.length) {
                int count = 0;
                int idx = this._predefinedRangeIndexes[k][0];
                int end = this._predefinedRangeIndexes[k][1];
                while (idx <= end) {
                    count += this._count[idx++];
                }
                int n = k++;
                rangeCounts[n] = rangeCounts[n] + count;
            }
            return new DefaultFacetIterator(this._predefinedRanges, rangeCounts, rangeCounts.length, true);
        }
        return null;
    }

    private static class RangeFacet
    extends BrowseFacet {
        private static final long serialVersionUID = 1L;
        String _lower;
        String _upper;

        RangeFacet() {
        }

        void setValues(String lower, String upper) {
            this._lower = lower;
            this._upper = upper;
            this.setValue("[" + this._lower + " TO " + this._upper + ']');
        }
    }
}

