/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.ComparatorFactory;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.FieldValueAccessor;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermDoubleList;
import com.browseengine.bobo.facets.data.TermFloatList;
import com.browseengine.bobo.facets.data.TermIntList;
import com.browseengine.bobo.facets.data.TermLongList;
import com.browseengine.bobo.facets.data.TermShortList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.impl.DefaultDoubleFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultFloatFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultIntFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultLongFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultShortFacetIterator;
import com.browseengine.bobo.facets.impl.FacetHitcountComparatorFactory;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.IntBoundedPriorityQueue;
import com.browseengine.bobo.util.MemoryManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DefaultFacetCountCollector
implements FacetCountCollector {
    private static final Logger log = Logger.getLogger((String)DefaultFacetCountCollector.class.getName());
    protected final FacetSpec _ospec;
    public int[] _count;
    public int _countlength;
    protected FacetDataCache _dataCache;
    private final String _name;
    protected final BrowseSelection _sel;
    protected final BigSegmentedArray _array;
    private int _docBase;
    protected LinkedList<int[]> intarraylist = new LinkedList();
    private Iterator _iterator;
    protected static MemoryManager<int[]> intarraymgr = new MemoryManager<int[]>(new MemoryManager.Initializer<int[]>(){

        @Override
        public void init(int[] buf) {
            Arrays.fill(buf, 0);
        }

        @Override
        public int[] newInstance(int size) {
            return new int[size];
        }

        @Override
        public int size(int[] buf) {
            assert (buf != null);
            return buf.length;
        }
    });

    public DefaultFacetCountCollector(String name, FacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
        this._sel = sel;
        this._ospec = ospec;
        this._name = name;
        this._dataCache = dataCache;
        if (this._dataCache.freqs.length <= 3096) {
            this._countlength = this._dataCache.freqs.length;
            this._count = new int[this._countlength];
        } else {
            this._countlength = this._dataCache.freqs.length;
            this._count = intarraymgr.get(this._countlength);
            this.intarraylist.add(this._count);
        }
        this._array = this._dataCache.orderArray;
        this._docBase = docBase;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public abstract void collect(int var1);

    @Override
    public abstract void collectAll();

    @Override
    public BrowseFacet getFacet(String value) {
        BrowseFacet facet = null;
        int index = this._dataCache.valArray.indexOf(value);
        facet = index >= 0 ? new BrowseFacet(this._dataCache.valArray.get(index), this._count[index]) : new BrowseFacet(this._dataCache.valArray.format(value), 0);
        return facet;
    }

    @Override
    public int[] getCountDistribution() {
        return this._count;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._ospec != null) {
            AbstractList facetColl;
            int minCount = this._ospec.getMinHitCount();
            int max = this._ospec.getMaxCount();
            if (max <= 0) {
                max = this._countlength;
            }
            TermValueList valList = this._dataCache.valArray;
            FacetSpec.FacetSortSpec sortspec = this._ospec.getOrderBy();
            if (sortspec == FacetSpec.FacetSortSpec.OrderValueAsc) {
                facetColl = new ArrayList<BrowseFacet>(max);
                for (int i = 1; i < this._countlength; ++i) {
                    int hits = this._count[i];
                    if (hits >= minCount) {
                        BrowseFacet facet = new BrowseFacet((String)valList.get(i), hits);
                        System.out.println("DefaultFacetCountCollector: Value --> " + (String)valList.get(i));
                        facetColl.add((BrowseFacet)facet);
                    }
                    if (facetColl.size() < max) {
                        continue;
                    }
                    break;
                }
            } else {
                int val;
                ComparatorFactory comparatorFactory = sortspec == FacetSpec.FacetSortSpec.OrderHitsDesc ? new FacetHitcountComparatorFactory() : this._ospec.getCustomComparatorFactory();
                if (comparatorFactory == null) {
                    throw new IllegalArgumentException("facet comparator factory not specified");
                }
                IntBoundedPriorityQueue.IntComparator comparator = comparatorFactory.newComparator(new FieldValueAccessor(){

                    @Override
                    public String getFormatedValue(int index) {
                        return DefaultFacetCountCollector.this._dataCache.valArray.get(index);
                    }

                    @Override
                    public Object getRawValue(int index) {
                        return DefaultFacetCountCollector.this._dataCache.valArray.getRawValue(index);
                    }
                }, this._count);
                facetColl = new LinkedList();
                int forbidden = -1;
                IntBoundedPriorityQueue pq = new IntBoundedPriorityQueue(comparator, max, -1);
                for (int i = 1; i < this._countlength; ++i) {
                    int hits = this._count[i];
                    if (hits < minCount) continue;
                    pq.offer(i);
                }
                while ((val = pq.pollInt()) != -1) {
                    BrowseFacet facet = new BrowseFacet((String)valList.get(val), this._count[val]);
                    ((LinkedList)facetColl).addFirst(facet);
                }
            }
            return facetColl;
        }
        return FacetCountCollector.EMPTY_FACET_LIST;
    }

    @Override
    public void close() {
        for (int[] buf : this.intarraylist) {
            intarraymgr.release(buf);
        }
    }

    @Override
    public FacetIterator iterator() {
        if (this._dataCache.valArray.getType().equals(Integer.class)) {
            return new DefaultIntFacetIterator((TermIntList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Long.class)) {
            return new DefaultLongFacetIterator((TermLongList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Short.class)) {
            return new DefaultShortFacetIterator((TermShortList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Float.class)) {
            return new DefaultFloatFacetIterator((TermFloatList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Double.class)) {
            return new DefaultDoubleFacetIterator((TermDoubleList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        return new DefaultFacetIterator(this._dataCache.valArray, this._count, this._countlength, false);
    }
}

