/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.FacetIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombinedFacetIterator
extends FacetIterator {
    private FacetIterator[] heap;
    private int size;
    List<FacetIterator> _iterators;

    public CombinedFacetIterator(List<FacetIterator> iterators) {
        this._iterators = iterators;
        this.heap = new FacetIterator[iterators.size() + 1];
        this.size = 0;
        for (FacetIterator iterator : iterators) {
            if (iterator.next(0) == null) continue;
            this.add(iterator);
        }
        this.facet = null;
        this.count = 0;
    }

    private final void add(FacetIterator element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
    }

    private final void upHeap() {
        int i = this.size;
        FacetIterator node = this.heap[i];
        Comparable val = node.facet;
        for (int j = i >>> 1; j > 0 && val.compareTo(this.heap[j].facet) < 0; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        FacetIterator node = this.heap[i];
        Comparable val = node.facet;
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k].facet.compareTo(this.heap[j].facet) < 0) {
            j = k;
        }
        while (j <= this.size && this.heap[j].facet.compareTo(val) < 0) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || this.heap[k].facet.compareTo(this.heap[j].facet) >= 0) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    private final void pop() {
        if (this.size > 0) {
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            if (--this.size > 0) {
                this.downHeap();
            }
        }
    }

    @Override
    public Comparable next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        return this.next(1);
    }

    @Override
    public Comparable next(int minHits) {
        int min;
        if (this.size == 0) {
            this.facet = null;
            this.count = 0;
            return null;
        }
        FacetIterator node = this.heap[1];
        this.facet = node.facet;
        this.count = node.count;
        int n = min = minHits > 0 ? 1 : 0;
        while (true) {
            if (node.next(min) != null) {
                this.downHeap();
                node = this.heap[1];
            } else {
                this.pop();
                if (this.size > 0) {
                    node = this.heap[1];
                } else {
                    if (this.count >= minHits) break;
                    this.facet = null;
                    this.count = 0;
                    break;
                }
            }
            Comparable next = node.facet;
            if (next == null) {
                throw new RuntimeException();
            }
            if (!next.equals(this.facet)) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node.count;
                continue;
            }
            this.count += node.count;
        }
        return this.format(this.facet);
    }

    @Override
    public boolean hasNext() {
        return this.size > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public String format(Object val) {
        return this._iterators.get(0).format(val);
    }
}

