/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BinaryBodyUtils;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxZipDownloadStatus;
import com.box.sdk.BoxZipInfo;
import com.box.sdk.BoxZipItem;
import com.box.sdk.ProgressListener;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;

public class BoxZip {
    public static final URLTemplate ZIP_URL_TEMPLATE = new URLTemplate("zip_downloads");
    private final BoxAPIConnection api;

    public BoxZip(BoxAPIConnection api) {
        this.api = api;
    }

    public BoxZipInfo create(String name, List<BoxZipItem> items) {
        JsonArray itemsArray = new JsonArray();
        for (BoxZipItem item : items) {
            itemsArray.add((JsonValue)item.getJSONObject());
        }
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("items", (JsonValue)itemsArray);
        requestJSON.add("download_file_name", name);
        URL url = ZIP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxZipInfo boxZipInfo = new BoxZipInfo(responseJSON);
            return boxZipInfo;
        }
    }

    public BoxZipDownloadStatus download(String name, List<BoxZipItem> items, OutputStream output) {
        return this.download(name, items, output, null);
    }

    public BoxZipDownloadStatus download(String name, List<BoxZipItem> items, OutputStream output, ProgressListener listener) {
        BoxZipInfo zipInfo = this.create(name, items);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), zipInfo.getDownloadURL(), "GET");
        BoxAPIResponse response = request.send();
        BinaryBodyUtils.writeStream(response, output, listener);
        BoxJSONRequest statusRequest = new BoxJSONRequest(this.getAPI(), zipInfo.getStatusURL(), "GET");
        try (BoxJSONResponse statusResponse = statusRequest.send();){
            JsonObject statusResponseJSON = Json.parse((String)statusResponse.getJSON()).asObject();
            BoxZipDownloadStatus boxZipDownloadStatus = new BoxZipDownloadStatus(statusResponseJSON);
            return boxZipDownloadStatus;
        }
    }

    public BoxAPIConnection getAPI() {
        return this.api;
    }
}

